/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed.DirectWriter;

public final class DirectMonotonicWriter {
    public static final int MIN_BLOCK_SHIFT = 2;
    public static final int MAX_BLOCK_SHIFT = 22;
    final IndexOutput meta;
    final IndexOutput data;
    final long numValues;
    final long baseDataPointer;
    final long[] buffer;
    int bufferSize;
    long count;
    boolean finished;
    long previous = Long.MIN_VALUE;

    DirectMonotonicWriter(IndexOutput metaOut, IndexOutput dataOut, long numValues, int blockShift) {
        long numBlocks;
        if (blockShift < 2 || blockShift > 22) {
            throw new IllegalArgumentException("blockShift must be in [2-22], got " + blockShift);
        }
        if (numValues < 0L) {
            throw new IllegalArgumentException("numValues can't be negative, got " + numValues);
        }
        long l = numBlocks = numValues == 0L ? 0L : (numValues - 1L >>> blockShift) + 1L;
        if (numBlocks > (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("blockShift is too low for the provided number of values: blockShift=" + blockShift + ", numValues=" + numValues + ", MAX_ARRAY_LENGTH=" + ArrayUtil.MAX_ARRAY_LENGTH);
        }
        this.meta = metaOut;
        this.data = dataOut;
        this.numValues = numValues;
        int blockSize = 1 << blockShift;
        this.buffer = new long[(int)Math.min(numValues, (long)blockSize)];
        this.bufferSize = 0;
        this.baseDataPointer = dataOut.getFilePointer();
    }

    private void flush() throws IOException {
        assert (this.bufferSize != 0);
        float avgInc = (float)((double)(this.buffer[this.bufferSize - 1] - this.buffer[0]) / (double)Math.max(1, this.bufferSize - 1));
        int i = 0;
        while (i < this.bufferSize) {
            long expected = (long)(avgInc * (float)i);
            int n = i++;
            this.buffer[n] = this.buffer[n] - expected;
        }
        long min2 = this.buffer[0];
        for (int i2 = 1; i2 < this.bufferSize; ++i2) {
            min2 = Math.min(this.buffer[i2], min2);
        }
        long maxDelta = 0L;
        for (int i3 = 0; i3 < this.bufferSize; ++i3) {
            int n = i3;
            this.buffer[n] = this.buffer[n] - min2;
            maxDelta |= this.buffer[i3];
        }
        this.meta.writeLong(min2);
        this.meta.writeInt(Float.floatToIntBits(avgInc));
        this.meta.writeLong(this.data.getFilePointer() - this.baseDataPointer);
        if (maxDelta == 0L) {
            this.meta.writeByte((byte)0);
        } else {
            int bitsRequired = DirectWriter.unsignedBitsRequired(maxDelta);
            DirectWriter writer = DirectWriter.getInstance(this.data, this.bufferSize, bitsRequired);
            for (int i4 = 0; i4 < this.bufferSize; ++i4) {
                writer.add(this.buffer[i4]);
            }
            writer.finish();
            this.meta.writeByte((byte)bitsRequired);
        }
        this.bufferSize = 0;
    }

    public void add(long v) throws IOException {
        if (v < this.previous) {
            throw new IllegalArgumentException("Values do not come in order: " + this.previous + ", " + v);
        }
        if (this.bufferSize == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.bufferSize++] = v;
        this.previous = v;
        ++this.count;
    }

    public void finish() throws IOException {
        if (this.count != this.numValues) {
            throw new IllegalStateException("Wrong number of values added, expected: " + this.numValues + ", got: " + this.count);
        }
        if (this.finished) {
            throw new IllegalStateException("#finish has been called already");
        }
        if (this.bufferSize > 0) {
            this.flush();
        }
        this.finished = true;
    }

    public static DirectMonotonicWriter getInstance(IndexOutput metaOut, IndexOutput dataOut, long numValues, int blockShift) {
        return new DirectMonotonicWriter(metaOut, dataOut, numValues, blockShift);
    }
}

