/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed.PackedInts;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed.PackedLongValues;

class DeltaPackedLongValues
extends PackedLongValues {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DeltaPackedLongValues.class);
    final long[] mins;

    DeltaPackedLongValues(int pageShift, int pageMask, PackedInts.Reader[] values, long[] mins, long size, long ramBytesUsed) {
        super(pageShift, pageMask, values, size, ramBytesUsed);
        assert (values.length == mins.length);
        this.mins = mins;
    }

    @Override
    long get(int block, int element) {
        return this.mins[block] + this.values[block].get(element);
    }

    @Override
    int decodeBlock(int block, long[] dest) {
        int count = super.decodeBlock(block, dest);
        long min2 = this.mins[block];
        int i = 0;
        while (i < count) {
            int n = i++;
            dest[n] = dest[n] + min2;
        }
        return count;
    }

    static class Builder
    extends PackedLongValues.Builder {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Builder.class);
        long[] mins;

        Builder(int pageSize, float acceptableOverheadRatio) {
            super(pageSize, acceptableOverheadRatio);
            this.mins = new long[this.values.length];
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.mins);
        }

        @Override
        long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        @Override
        public DeltaPackedLongValues build() {
            this.finish();
            this.pending = null;
            Accountable[] values = ArrayUtil.copyOfSubArray(this.values, 0, this.valuesOff);
            long[] mins = ArrayUtil.copyOfSubArray(this.mins, 0, this.valuesOff);
            long ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(values) + RamUsageEstimator.sizeOf(mins);
            return new DeltaPackedLongValues(this.pageShift, this.pageMask, (PackedInts.Reader[])values, mins, this.size, ramBytesUsed);
        }

        @Override
        void pack(long[] values, int numValues, int block, float acceptableOverheadRatio) {
            int i;
            long min2 = values[0];
            for (i = 1; i < numValues; ++i) {
                min2 = Math.min(min2, values[i]);
            }
            i = 0;
            while (i < numValues) {
                int n = i++;
                values[n] = values[n] - min2;
            }
            super.pack(values, numValues, block, acceptableOverheadRatio);
            this.mins[block] = min2;
        }

        @Override
        void grow(int newBlockCount) {
            super.grow(newBlockCount);
            this.ramBytesUsed -= RamUsageEstimator.sizeOf(this.mins);
            this.mins = ArrayUtil.growExact(this.mins, newBlockCount);
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.mins);
        }
    }
}

