/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.bkd;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.MutablePointValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.FutureArrays;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IntroSelector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IntroSorter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.MSBRadixSorter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.RadixSelector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Selector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Sorter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed.PackedInts;

public final class MutablePointsReaderUtils {
    MutablePointsReaderUtils() {
    }

    public static void sort(int maxDoc, final int packedBytesLength, final MutablePointValues reader, int from, int to) {
        final int bitsPerDocId = PackedInts.bitsRequired(maxDoc - 1);
        new MSBRadixSorter(packedBytesLength + (bitsPerDocId + 7) / 8){

            @Override
            protected void swap(int i, int j) {
                reader.swap(i, j);
            }

            @Override
            protected int byteAt(int i, int k) {
                if (k < packedBytesLength) {
                    return Byte.toUnsignedInt(reader.getByteAt(i, k));
                }
                int shift = bitsPerDocId - (k - packedBytesLength + 1 << 3);
                return reader.getDocID(i) >>> Math.max(0, shift) & 0xFF;
            }

            @Override
            protected Sorter getFallbackSorter(final int k) {
                return new IntroSorter(){
                    final BytesRef pivot = new BytesRef();
                    final BytesRef scratch = new BytesRef();
                    int pivotDoc;

                    @Override
                    protected void swap(int i, int j) {
                        reader.swap(i, j);
                    }

                    @Override
                    protected void setPivot(int i) {
                        reader.getValue(i, this.pivot);
                        this.pivotDoc = reader.getDocID(i);
                    }

                    @Override
                    protected int comparePivot(int j) {
                        if (k < packedBytesLength) {
                            reader.getValue(j, this.scratch);
                            int cmp = FutureArrays.compareUnsigned(this.pivot.bytes, this.pivot.offset + k, this.pivot.offset + k + packedBytesLength - k, this.scratch.bytes, this.scratch.offset + k, this.scratch.offset + k + packedBytesLength - k);
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        return this.pivotDoc - reader.getDocID(j);
                    }
                };
            }
        }.sort(from, to);
    }

    public static void sortByDim(int numDataDim, int numIndexDim, int sortedDim, int bytesPerDim, int[] commonPrefixLengths, final MutablePointValues reader, int from, int to, final BytesRef scratch1, final BytesRef scratch2) {
        final int start = sortedDim * bytesPerDim + commonPrefixLengths[sortedDim];
        final int dimEnd = sortedDim * bytesPerDim + bytesPerDim;
        final int dataStart = numIndexDim * bytesPerDim;
        final int dataEnd = dataStart + (numDataDim - numIndexDim) * bytesPerDim;
        new IntroSorter(){
            final BytesRef pivot;
            int pivotDoc;
            {
                this.pivot = scratch1;
                this.pivotDoc = -1;
            }

            @Override
            protected void swap(int i, int j) {
                reader.swap(i, j);
            }

            @Override
            protected void setPivot(int i) {
                reader.getValue(i, this.pivot);
                this.pivotDoc = reader.getDocID(i);
            }

            @Override
            protected int comparePivot(int j) {
                reader.getValue(j, scratch2);
                int cmp = FutureArrays.compareUnsigned(this.pivot.bytes, this.pivot.offset + start, this.pivot.offset + dimEnd, scratch2.bytes, scratch2.offset + start, scratch2.offset + dimEnd);
                if (cmp == 0 && (cmp = FutureArrays.compareUnsigned(this.pivot.bytes, this.pivot.offset + dataStart, this.pivot.offset + dataEnd, scratch2.bytes, scratch2.offset + dataStart, scratch2.offset + dataEnd)) == 0) {
                    cmp = this.pivotDoc - reader.getDocID(j);
                }
                return cmp;
            }
        }.sort(from, to);
    }

    public static void partition(final int numDataDim, int numIndexDim, int maxDoc, int splitDim, final int bytesPerDim, int commonPrefixLen, final MutablePointValues reader, int from, int to, int mid, final BytesRef scratch1, final BytesRef scratch2) {
        final int dimOffset = splitDim * bytesPerDim + commonPrefixLen;
        final int dimCmpBytes = bytesPerDim - commonPrefixLen;
        final int dataOffset = numIndexDim * bytesPerDim;
        final int dataCmpBytes = (numDataDim - numIndexDim) * bytesPerDim + dimCmpBytes;
        final int bitsPerDocId = PackedInts.bitsRequired(maxDoc - 1);
        new RadixSelector(dataCmpBytes + (bitsPerDocId + 7) / 8){

            @Override
            protected Selector getFallbackSelector(final int k) {
                final int dataStart = k < dimCmpBytes ? dataOffset : dataOffset + k - dimCmpBytes;
                final int dataEnd = numDataDim * bytesPerDim;
                return new IntroSelector(){
                    final BytesRef pivot;
                    int pivotDoc;
                    {
                        this.pivot = scratch1;
                    }

                    @Override
                    protected void swap(int i, int j) {
                        reader.swap(i, j);
                    }

                    @Override
                    protected void setPivot(int i) {
                        reader.getValue(i, this.pivot);
                        this.pivotDoc = reader.getDocID(i);
                    }

                    @Override
                    protected int comparePivot(int j) {
                        int cmp;
                        if (k < dimCmpBytes) {
                            reader.getValue(j, scratch2);
                            cmp = FutureArrays.compareUnsigned(this.pivot.bytes, this.pivot.offset + dimOffset + k, this.pivot.offset + dimOffset + dimCmpBytes, scratch2.bytes, scratch2.offset + dimOffset + k, scratch2.offset + dimOffset + dimCmpBytes);
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        if (k < dataCmpBytes) {
                            reader.getValue(j, scratch2);
                            cmp = FutureArrays.compareUnsigned(this.pivot.bytes, this.pivot.offset + dataStart, this.pivot.offset + dataEnd, scratch2.bytes, scratch2.offset + dataStart, scratch2.offset + dataEnd);
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        return this.pivotDoc - reader.getDocID(j);
                    }
                };
            }

            @Override
            protected void swap(int i, int j) {
                reader.swap(i, j);
            }

            @Override
            protected int byteAt(int i, int k) {
                if (k < dimCmpBytes) {
                    return Byte.toUnsignedInt(reader.getByteAt(i, dimOffset + k));
                }
                if (k < dataCmpBytes) {
                    return Byte.toUnsignedInt(reader.getByteAt(i, dataOffset + k - dimCmpBytes));
                }
                int shift = bitsPerDocId - (k - dataCmpBytes + 1 << 3);
                return reader.getDocID(i) >>> Math.max(0, shift) & 0xFF;
            }
        }.select(from, to, mid);
    }
}

