/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.FilterDirectory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.RAMDirectory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountables;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IOUtils;

public class NRTCachingDirectory
extends FilterDirectory
implements Accountable {
    private final RAMDirectory cache = new RAMDirectory();
    private final long maxMergeSizeBytes;
    private final long maxCachedBytes;
    private static final boolean VERBOSE = false;
    private final Object uncacheLock = new Object();

    public NRTCachingDirectory(Directory delegate, double maxMergeSizeMB, double maxCachedMB) {
        super(delegate);
        this.maxMergeSizeBytes = (long)(maxMergeSizeMB * 1024.0 * 1024.0);
        this.maxCachedBytes = (long)(maxCachedMB * 1024.0 * 1024.0);
    }

    @Override
    public String toString() {
        return "NRTCachingDirectory(" + this.in + "; maxCacheMB=" + (double)(this.maxCachedBytes / 1024L) / 1024.0 + " maxMergeSizeMB=" + (double)(this.maxMergeSizeBytes / 1024L) / 1024.0 + ")";
    }

    @Override
    public synchronized String[] listAll() throws IOException {
        HashSet<String> files = new HashSet<String>();
        for (String f : this.cache.listAll()) {
            files.add(f);
        }
        for (String f : this.in.listAll()) {
            files.add(f);
        }
        Object[] result = files.toArray(new String[files.size()]);
        Arrays.sort(result);
        return result;
    }

    @Override
    public synchronized void deleteFile(String name) throws IOException {
        if (this.cache.fileNameExists(name)) {
            this.cache.deleteFile(name);
        } else {
            this.in.deleteFile(name);
        }
    }

    @Override
    public synchronized long fileLength(String name) throws IOException {
        if (this.cache.fileNameExists(name)) {
            return this.cache.fileLength(name);
        }
        return this.in.fileLength(name);
    }

    public String[] listCachedFiles() {
        return this.cache.listAll();
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        if (this.doCacheWrite(name, context)) {
            return this.cache.createOutput(name, context);
        }
        return this.in.createOutput(name, context);
    }

    @Override
    public void sync(Collection<String> fileNames) throws IOException {
        for (String fileName : fileNames) {
            this.unCache(fileName);
        }
        this.in.sync(fileNames);
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        this.unCache(source);
        if (this.cache.fileNameExists(dest)) {
            throw new IllegalArgumentException("target file " + dest + " already exists");
        }
        this.in.rename(source, dest);
    }

    @Override
    public synchronized IndexInput openInput(String name, IOContext context) throws IOException {
        if (this.cache.fileNameExists(name)) {
            return this.cache.openInput(name, context);
        }
        return this.in.openInput(name, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.cache.isOpen) {
                        for (String fileName : this.cache.listAll()) {
                            this.unCache(fileName);
                        }
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.cache, this.in);
                    } else {
                        IOUtils.closeWhileHandlingException(this.cache, this.in);
                    }
                    throw throwable;
                }
                IOUtils.close(this.cache, this.in);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.cache, this.in);
        }
    }

    protected boolean doCacheWrite(String name, IOContext context) {
        long bytes = 0L;
        if (context.mergeInfo != null) {
            bytes = context.mergeInfo.estimatedMergeBytes;
        } else if (context.flushInfo != null) {
            bytes = context.flushInfo.estimatedSegmentSize;
        } else {
            return false;
        }
        return bytes <= this.maxMergeSizeBytes && bytes + this.cache.ramBytesUsed() <= this.maxCachedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        IndexOutput out;
        block8: {
            Directory first;
            HashSet<String> toDelete;
            block7: {
                Directory second;
                toDelete = new HashSet<String>();
                boolean success = false;
                if (this.doCacheWrite(prefix, context)) {
                    first = this.cache;
                    second = this.in;
                } else {
                    first = this.in;
                    second = this.cache;
                }
                out = null;
                try {
                    String name;
                    while (true) {
                        out = first.createTempOutput(prefix, suffix, context);
                        name = out.getName();
                        toDelete.add(name);
                        if (!NRTCachingDirectory.slowFileExists(second, name)) break;
                        out.close();
                    }
                    toDelete.remove(name);
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.deleteFiles(first, toDelete);
                    } else {
                        IOUtils.closeWhileHandlingException(out);
                        IOUtils.deleteFilesIgnoringExceptions(first, toDelete);
                    }
                    throw throwable;
                }
                IOUtils.deleteFiles(first, toDelete);
                break block8;
            }
            IOUtils.closeWhileHandlingException(out);
            IOUtils.deleteFilesIgnoringExceptions(first, toDelete);
        }
        return out;
    }

    static boolean slowFileExists(Directory dir, String fileName) throws IOException {
        try {
            dir.openInput(fileName, IOContext.DEFAULT).close();
            return true;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unCache(String fileName) throws IOException {
        Object object = this.uncacheLock;
        synchronized (object) {
            if (!this.cache.fileNameExists(fileName)) {
                return;
            }
            assert (!NRTCachingDirectory.slowFileExists(this.in, fileName)) : "fileName=" + fileName + " exists both in cache and in delegate";
            IOContext context = IOContext.DEFAULT;
            IndexOutput out = this.in.createOutput(fileName, context);
            IndexInput in = null;
            try {
                in = this.cache.openInput(fileName, context);
                out.copyBytes(in, in.length());
            }
            catch (Throwable throwable) {
                IOUtils.close(in, out);
                throw throwable;
            }
            IOUtils.close(in, out);
            NRTCachingDirectory nRTCachingDirectory = this;
            synchronized (nRTCachingDirectory) {
                this.cache.deleteFile(fileName);
            }
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.cache.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.singleton(Accountables.namedAccountable("cache", this.cache));
    }
}

