/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.tst;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.tst.TernaryTreeNode;

public class TSTAutocomplete {
    TSTAutocomplete() {
    }

    public void balancedTree(Object[] tokens, Object[] vals, int lo, int hi, TernaryTreeNode root) {
        if (lo > hi) {
            return;
        }
        int mid = (lo + hi) / 2;
        root = this.insert(root, (String)tokens[mid], vals[mid], 0);
        this.balancedTree(tokens, vals, lo, mid - 1, root);
        this.balancedTree(tokens, vals, mid + 1, hi, root);
    }

    /*
     * Enabled aggressive block sorting
     */
    public TernaryTreeNode insert(TernaryTreeNode currentNode, CharSequence s2, Object val2, int x) {
        if (s2 == null) return currentNode;
        if (s2.length() <= x) {
            return currentNode;
        }
        if (currentNode == null) {
            TernaryTreeNode newNode = new TernaryTreeNode();
            newNode.splitchar = s2.charAt(x);
            currentNode = newNode;
            if (x < s2.length() - 1) {
                currentNode.eqKid = this.insert(currentNode.eqKid, s2, val2, x + 1);
                return currentNode;
            }
            currentNode.token = s2.toString();
            currentNode.val = val2;
            return currentNode;
        }
        if (currentNode.splitchar > s2.charAt(x)) {
            currentNode.loKid = this.insert(currentNode.loKid, s2, val2, x);
            return currentNode;
        }
        if (currentNode.splitchar != s2.charAt(x)) {
            currentNode.hiKid = this.insert(currentNode.hiKid, s2, val2, x);
            return currentNode;
        }
        if (x < s2.length() - 1) {
            currentNode.eqKid = this.insert(currentNode.eqKid, s2, val2, x + 1);
            return currentNode;
        }
        currentNode.token = s2.toString();
        currentNode.val = val2;
        return currentNode;
    }

    public ArrayList<TernaryTreeNode> prefixCompletion(TernaryTreeNode root, CharSequence s2, int x) {
        TernaryTreeNode p = root;
        ArrayList<TernaryTreeNode> suggest = new ArrayList<TernaryTreeNode>();
        while (p != null) {
            if (s2.charAt(x) < p.splitchar) {
                p = p.loKid;
                continue;
            }
            if (s2.charAt(x) == p.splitchar) {
                if (x == s2.length() - 1) break;
                ++x;
                p = p.eqKid;
                continue;
            }
            p = p.hiKid;
        }
        if (p == null) {
            return suggest;
        }
        if (p.eqKid == null && p.token == null) {
            return suggest;
        }
        if (p.eqKid == null && p.token != null) {
            suggest.add(p);
            return suggest;
        }
        if (p.token != null) {
            suggest.add(p);
        }
        p = p.eqKid;
        Stack<TernaryTreeNode> st = new Stack<TernaryTreeNode>();
        st.push(p);
        while (!st.empty()) {
            TernaryTreeNode top = (TernaryTreeNode)st.peek();
            st.pop();
            if (top.token != null) {
                suggest.add(top);
            }
            if (top.eqKid != null) {
                st.push(top.eqKid);
            }
            if (top.loKid != null) {
                st.push(top.loKid);
            }
            if (top.hiKid == null) continue;
            st.push(top.hiKid);
        }
        return suggest;
    }
}

