/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.document;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.Lookup;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.document.TopSuggestDocs;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.PriorityQueue;

final class SuggestScoreDocPriorityQueue
extends PriorityQueue<TopSuggestDocs.SuggestScoreDoc> {
    public SuggestScoreDocPriorityQueue(int size) {
        super(size);
    }

    @Override
    protected boolean lessThan(TopSuggestDocs.SuggestScoreDoc a, TopSuggestDocs.SuggestScoreDoc b) {
        if (a.score == b.score) {
            int cmp = Lookup.CHARSEQUENCE_COMPARATOR.compare(a.key, b.key);
            return cmp != 0 ? cmp > 0 : a.doc > b.doc;
        }
        return a.score < b.score;
    }

    public TopSuggestDocs.SuggestScoreDoc[] getResults() {
        int size = this.size();
        TopSuggestDocs.SuggestScoreDoc[] res = new TopSuggestDocs.SuggestScoreDoc[size];
        for (int i = size - 1; i >= 0; --i) {
            res[i] = (TopSuggestDocs.SuggestScoreDoc)this.pop();
        }
        return res;
    }
}

