/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.InputIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRefArray;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Counter;

public class BufferedInputIterator
implements InputIterator {
    protected BytesRefArray entries = new BytesRefArray(Counter.newCounter());
    protected BytesRefArray payloads = new BytesRefArray(Counter.newCounter());
    protected List<Set<BytesRef>> contextSets = new ArrayList<Set<BytesRef>>();
    protected int curPos = -1;
    protected long[] freqs = new long[1];
    private final BytesRefBuilder spare = new BytesRefBuilder();
    private final BytesRefBuilder payloadSpare = new BytesRefBuilder();
    private final boolean hasPayloads;
    private final boolean hasContexts;

    public BufferedInputIterator(InputIterator source) throws IOException {
        BytesRef spare;
        int freqIndex = 0;
        this.hasPayloads = source.hasPayloads();
        this.hasContexts = source.hasContexts();
        while ((spare = source.next()) != null) {
            this.entries.append(spare);
            if (this.hasPayloads) {
                this.payloads.append(source.payload());
            }
            if (this.hasContexts) {
                this.contextSets.add(source.contexts());
            }
            if (freqIndex >= this.freqs.length) {
                this.freqs = ArrayUtil.grow(this.freqs, this.freqs.length + 1);
            }
            this.freqs[freqIndex++] = source.weight();
        }
    }

    @Override
    public long weight() {
        return this.freqs[this.curPos];
    }

    @Override
    public BytesRef next() throws IOException {
        if (++this.curPos < this.entries.size()) {
            this.entries.get(this.spare, this.curPos);
            return this.spare.get();
        }
        return null;
    }

    @Override
    public BytesRef payload() {
        if (this.hasPayloads && this.curPos < this.payloads.size()) {
            return this.payloads.get(this.payloadSpare, this.curPos);
        }
        return null;
    }

    @Override
    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    @Override
    public Set<BytesRef> contexts() {
        if (this.hasContexts && this.curPos < this.contextSets.size()) {
            return this.contextSets.get(this.curPos);
        }
        return null;
    }

    @Override
    public boolean hasContexts() {
        return this.hasContexts;
    }
}

