/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.BasicStats;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.LMSimilarity;

public class LMJelinekMercerSimilarity
extends LMSimilarity {
    private final float lambda;

    public LMJelinekMercerSimilarity(LMSimilarity.CollectionModel collectionModel, float lambda) {
        super(collectionModel);
        if (Float.isNaN(lambda) || lambda <= 0.0f || lambda > 1.0f) {
            throw new IllegalArgumentException("lambda must be in the range (0 .. 1]");
        }
        this.lambda = lambda;
    }

    public LMJelinekMercerSimilarity(float lambda) {
        if (Float.isNaN(lambda) || lambda <= 0.0f || lambda > 1.0f) {
            throw new IllegalArgumentException("lambda must be in the range (0 .. 1]");
        }
        this.lambda = lambda;
    }

    @Override
    protected double score(BasicStats stats, double freq, double docLen) {
        return stats.getBoost() * Math.log(1.0 + (double)(1.0f - this.lambda) * freq / docLen / ((double)this.lambda * ((LMSimilarity.LMStats)stats).getCollectionProbability()));
    }

    @Override
    protected void explain(List<Explanation> subs, BasicStats stats, double freq, double docLen) {
        if (stats.getBoost() != 1.0) {
            subs.add(Explanation.match((Number)Float.valueOf((float)stats.getBoost()), "boost", new Explanation[0]));
        }
        subs.add(Explanation.match((Number)Float.valueOf(this.lambda), "lambda", new Explanation[0]));
        double p = ((LMSimilarity.LMStats)stats).getCollectionProbability();
        Explanation explP = Explanation.match((Number)Float.valueOf((float)p), "P, probability that the current term is generated by the collection", new Explanation[0]);
        subs.add(explP);
        Explanation explFreq = Explanation.match((Number)Float.valueOf((float)freq), "freq, number of occurrences of term in the document", new Explanation[0]);
        subs.add(explFreq);
        subs.add(Explanation.match((Number)Float.valueOf((float)docLen), "dl, length of field", new Explanation[0]));
        super.explain(subs, stats, freq, docLen);
    }

    @Override
    protected Explanation explain(BasicStats stats, Explanation freq, double docLen) {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        this.explain(subs, stats, freq.getValue().doubleValue(), docLen);
        return Explanation.match((Number)Float.valueOf((float)this.score(stats, freq.getValue().doubleValue(), docLen)), "score(" + this.getClass().getSimpleName() + ", freq=" + freq.getValue() + "), computed as boost * log(1 + ((1 - lambda) * freq / dl) /(lambda * P)) from:", subs);
    }

    public float getLambda() {
        return this.lambda;
    }

    @Override
    public String getName() {
        return String.format(Locale.ROOT, "Jelinek-Mercer(%f)", Float.valueOf(this.getLambda()));
    }
}

