/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocValuesType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;

public class FieldInfos
implements Iterable<FieldInfo> {
    public static final FieldInfos EMPTY = new FieldInfos(new FieldInfo[0]);
    private final boolean hasFreq;
    private final boolean hasProx;
    private final boolean hasPayloads;
    private final boolean hasOffsets;
    private final boolean hasVectors;
    private final boolean hasNorms;
    private final boolean hasDocValues;
    private final boolean hasPointValues;
    private final String softDeletesField;
    private final FieldInfo[] byNumber;
    private final HashMap<String, FieldInfo> byName = new HashMap();
    private final Collection<FieldInfo> values;

    public FieldInfos(FieldInfo[] infos) {
        boolean hasVectors = false;
        boolean hasProx = false;
        boolean hasPayloads = false;
        boolean hasOffsets = false;
        boolean hasFreq = false;
        boolean hasNorms = false;
        boolean hasDocValues = false;
        boolean hasPointValues = false;
        String softDeletesField = null;
        int size = 0;
        FieldInfo[] byNumberTemp = new FieldInfo[10];
        for (FieldInfo info : infos) {
            FieldInfo previous;
            if (info.number < 0) {
                throw new IllegalArgumentException("illegal field number: " + info.number + " for field " + info.name);
            }
            int n = size = info.number >= size ? info.number + 1 : size;
            if (info.number >= byNumberTemp.length) {
                byNumberTemp = ArrayUtil.grow(byNumberTemp, info.number + 1);
            }
            if ((previous = byNumberTemp[info.number]) != null) {
                throw new IllegalArgumentException("duplicate field numbers: " + previous.name + " and " + info.name + " have: " + info.number);
            }
            byNumberTemp[info.number] = info;
            previous = this.byName.put(info.name, info);
            if (previous != null) {
                throw new IllegalArgumentException("duplicate field names: " + previous.number + " and " + info.number + " have: " + info.name);
            }
            hasVectors |= info.hasVectors();
            hasProx |= info.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            hasFreq |= info.getIndexOptions() != IndexOptions.DOCS;
            hasOffsets |= info.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            hasNorms |= info.hasNorms();
            hasDocValues |= info.getDocValuesType() != DocValuesType.NONE;
            hasPayloads |= info.hasPayloads();
            hasPointValues |= info.getPointDimensionCount() != 0;
            if (!info.isSoftDeletesField()) continue;
            if (softDeletesField != null && !softDeletesField.equals(info.name)) {
                throw new IllegalArgumentException("multiple soft-deletes fields [" + info.name + ", " + softDeletesField + "]");
            }
            softDeletesField = info.name;
        }
        this.hasVectors = hasVectors;
        this.hasProx = hasProx;
        this.hasPayloads = hasPayloads;
        this.hasOffsets = hasOffsets;
        this.hasFreq = hasFreq;
        this.hasNorms = hasNorms;
        this.hasDocValues = hasDocValues;
        this.hasPointValues = hasPointValues;
        this.softDeletesField = softDeletesField;
        ArrayList<FieldInfo> valuesTemp = new ArrayList<FieldInfo>();
        this.byNumber = new FieldInfo[size];
        for (int i = 0; i < size; ++i) {
            this.byNumber[i] = byNumberTemp[i];
            if (byNumberTemp[i] == null) continue;
            valuesTemp.add(byNumberTemp[i]);
        }
        this.values = Collections.unmodifiableCollection(Arrays.asList(valuesTemp.toArray(new FieldInfo[0])));
    }

    public static FieldInfos getMergedFieldInfos(IndexReader reader) {
        List<LeafReaderContext> leaves = reader.leaves();
        if (leaves.isEmpty()) {
            return EMPTY;
        }
        if (leaves.size() == 1) {
            return leaves.get(0).reader().getFieldInfos();
        }
        String softDeletesField = leaves.stream().map(l -> l.reader().getFieldInfos().getSoftDeletesField()).filter(Objects::nonNull).findAny().orElse(null);
        Builder builder = new Builder(new FieldNumbers(softDeletesField));
        for (LeafReaderContext ctx : leaves) {
            builder.add(ctx.reader().getFieldInfos());
        }
        return builder.finish();
    }

    public static Collection<String> getIndexedFields(IndexReader reader) {
        return reader.leaves().stream().flatMap(l -> StreamSupport.stream(l.reader().getFieldInfos().spliterator(), false).filter(fi -> fi.getIndexOptions() != IndexOptions.NONE)).map(fi -> fi.name).collect(Collectors.toSet());
    }

    public boolean hasFreq() {
        return this.hasFreq;
    }

    public boolean hasProx() {
        return this.hasProx;
    }

    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    public boolean hasOffsets() {
        return this.hasOffsets;
    }

    public boolean hasVectors() {
        return this.hasVectors;
    }

    public boolean hasNorms() {
        return this.hasNorms;
    }

    public boolean hasDocValues() {
        return this.hasDocValues;
    }

    public boolean hasPointValues() {
        return this.hasPointValues;
    }

    public String getSoftDeletesField() {
        return this.softDeletesField;
    }

    public int size() {
        return this.byName.size();
    }

    @Override
    public Iterator<FieldInfo> iterator() {
        return this.values.iterator();
    }

    public FieldInfo fieldInfo(String fieldName) {
        return this.byName.get(fieldName);
    }

    public FieldInfo fieldInfo(int fieldNumber) {
        if (fieldNumber < 0) {
            throw new IllegalArgumentException("Illegal field number: " + fieldNumber);
        }
        if (fieldNumber >= this.byNumber.length) {
            return null;
        }
        return this.byNumber[fieldNumber];
    }

    static final class Builder {
        private final HashMap<String, FieldInfo> byName = new HashMap();
        final FieldNumbers globalFieldNumbers;
        private boolean finished;

        Builder(FieldNumbers globalFieldNumbers) {
            assert (globalFieldNumbers != null);
            this.globalFieldNumbers = globalFieldNumbers;
        }

        public void add(FieldInfos other) {
            assert (this.assertNotFinished());
            for (FieldInfo fieldInfo : other) {
                this.add(fieldInfo);
            }
        }

        public FieldInfo getOrAdd(String name) {
            FieldInfo fi = this.fieldInfo(name);
            if (fi == null) {
                assert (this.assertNotFinished());
                boolean isSoftDeletesField = name.equals(this.globalFieldNumbers.softDeletesFieldName);
                int fieldNumber = this.globalFieldNumbers.addOrGet(name, -1, IndexOptions.NONE, DocValuesType.NONE, 0, 0, 0, isSoftDeletesField);
                fi = new FieldInfo(name, fieldNumber, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, new HashMap<String, String>(), 0, 0, 0, isSoftDeletesField);
                assert (!this.byName.containsKey(fi.name));
                this.globalFieldNumbers.verifyConsistent((Integer)fi.number, fi.name, DocValuesType.NONE);
                this.byName.put(fi.name, fi);
            }
            return fi;
        }

        private FieldInfo addOrUpdateInternal(String name, int preferredFieldNumber, boolean storeTermVector, boolean omitNorms, boolean storePayloads, IndexOptions indexOptions, DocValuesType docValues, long dvGen, Map<String, String> attributes, int dataDimensionCount, int indexDimensionCount, int dimensionNumBytes, boolean isSoftDeletesField) {
            FieldInfo fi;
            assert (this.assertNotFinished());
            if (docValues == null) {
                throw new NullPointerException("DocValuesType must not be null");
            }
            if (attributes != null) {
                attributes = new HashMap<String, String>(attributes);
            }
            if ((fi = this.fieldInfo(name)) == null) {
                int fieldNumber = this.globalFieldNumbers.addOrGet(name, preferredFieldNumber, indexOptions, docValues, dataDimensionCount, indexDimensionCount, dimensionNumBytes, isSoftDeletesField);
                fi = new FieldInfo(name, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValues, dvGen, attributes, dataDimensionCount, indexDimensionCount, dimensionNumBytes, isSoftDeletesField);
                assert (!this.byName.containsKey(fi.name));
                this.globalFieldNumbers.verifyConsistent((Integer)fi.number, fi.name, fi.getDocValuesType());
                this.byName.put(fi.name, fi);
            } else {
                fi.update(storeTermVector, omitNorms, storePayloads, indexOptions, attributes, dataDimensionCount, indexDimensionCount, dimensionNumBytes);
                if (docValues != DocValuesType.NONE) {
                    boolean updateGlobal;
                    boolean bl = updateGlobal = fi.getDocValuesType() == DocValuesType.NONE;
                    if (updateGlobal) {
                        this.globalFieldNumbers.setDocValuesType(fi.number, name, docValues);
                    }
                    fi.setDocValuesType(docValues);
                    fi.setDocValuesGen(dvGen);
                }
            }
            return fi;
        }

        public FieldInfo add(FieldInfo fi) {
            return this.add(fi, -1L);
        }

        public FieldInfo add(FieldInfo fi, long dvGen) {
            return this.addOrUpdateInternal(fi.name, fi.number, fi.hasVectors(), fi.omitsNorms(), fi.hasPayloads(), fi.getIndexOptions(), fi.getDocValuesType(), dvGen, fi.attributes(), fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes(), fi.isSoftDeletesField());
        }

        public FieldInfo fieldInfo(String fieldName) {
            return this.byName.get(fieldName);
        }

        private boolean assertNotFinished() {
            if (this.finished) {
                throw new IllegalStateException("FieldInfos.Builder was already finished; cannot add new fields");
            }
            return true;
        }

        FieldInfos finish() {
            this.finished = true;
            return new FieldInfos(this.byName.values().toArray(new FieldInfo[this.byName.size()]));
        }
    }

    static final class FieldNumbers {
        private final Map<Integer, String> numberToName;
        private final Map<String, Integer> nameToNumber = new HashMap<String, Integer>();
        private final Map<String, IndexOptions> indexOptions;
        private final Map<String, DocValuesType> docValuesType;
        private final Map<String, FieldDimensions> dimensions;
        private int lowestUnassignedFieldNumber = -1;
        private final String softDeletesFieldName;

        FieldNumbers(String softDeletesFieldName) {
            this.numberToName = new HashMap<Integer, String>();
            this.indexOptions = new HashMap<String, IndexOptions>();
            this.docValuesType = new HashMap<String, DocValuesType>();
            this.dimensions = new HashMap<String, FieldDimensions>();
            this.softDeletesFieldName = softDeletesFieldName;
        }

        synchronized int addOrGet(String fieldName, int preferredFieldNumber, IndexOptions indexOptions, DocValuesType dvType, int dimensionCount, int indexDimensionCount, int dimensionNumBytes, boolean isSoftDeletesField) {
            Integer fieldNumber;
            if (indexOptions != IndexOptions.NONE) {
                IndexOptions currentOpts = this.indexOptions.get(fieldName);
                if (currentOpts == null) {
                    this.indexOptions.put(fieldName, indexOptions);
                } else if (currentOpts != IndexOptions.NONE && currentOpts != indexOptions) {
                    throw new IllegalArgumentException("cannot change field \"" + fieldName + "\" from index options=" + (Object)((Object)currentOpts) + " to inconsistent index options=" + (Object)((Object)indexOptions));
                }
            }
            if (dvType != DocValuesType.NONE) {
                DocValuesType currentDVType = this.docValuesType.get(fieldName);
                if (currentDVType == null) {
                    this.docValuesType.put(fieldName, dvType);
                } else if (currentDVType != DocValuesType.NONE && currentDVType != dvType) {
                    throw new IllegalArgumentException("cannot change DocValues type from " + (Object)((Object)currentDVType) + " to " + (Object)((Object)dvType) + " for field \"" + fieldName + "\"");
                }
            }
            if (dimensionCount != 0) {
                FieldDimensions dims = this.dimensions.get(fieldName);
                if (dims != null) {
                    if (dims.dimensionCount != dimensionCount) {
                        throw new IllegalArgumentException("cannot change point dimension count from " + dims.dimensionCount + " to " + dimensionCount + " for field=\"" + fieldName + "\"");
                    }
                    if (dims.indexDimensionCount != indexDimensionCount) {
                        throw new IllegalArgumentException("cannot change point index dimension count from " + dims.indexDimensionCount + " to " + indexDimensionCount + " for field=\"" + fieldName + "\"");
                    }
                    if (dims.dimensionNumBytes != dimensionNumBytes) {
                        throw new IllegalArgumentException("cannot change point numBytes from " + dims.dimensionNumBytes + " to " + dimensionNumBytes + " for field=\"" + fieldName + "\"");
                    }
                } else {
                    this.dimensions.put(fieldName, new FieldDimensions(dimensionCount, indexDimensionCount, dimensionNumBytes));
                }
            }
            if ((fieldNumber = this.nameToNumber.get(fieldName)) == null) {
                Integer preferredBoxed = preferredFieldNumber;
                if (preferredFieldNumber != -1 && !this.numberToName.containsKey(preferredBoxed)) {
                    fieldNumber = preferredBoxed;
                } else {
                    while (this.numberToName.containsKey(++this.lowestUnassignedFieldNumber)) {
                    }
                    fieldNumber = this.lowestUnassignedFieldNumber;
                }
                assert (fieldNumber >= 0);
                this.numberToName.put(fieldNumber, fieldName);
                this.nameToNumber.put(fieldName, fieldNumber);
            }
            if (isSoftDeletesField) {
                if (this.softDeletesFieldName == null) {
                    throw new IllegalArgumentException("this index has [" + fieldName + "] as soft-deletes already but soft-deletes field is not configured in IWC");
                }
                if (!fieldName.equals(this.softDeletesFieldName)) {
                    throw new IllegalArgumentException("cannot configure [" + this.softDeletesFieldName + "] as soft-deletes; this index uses [" + fieldName + "] as soft-deletes already");
                }
            } else if (fieldName.equals(this.softDeletesFieldName)) {
                throw new IllegalArgumentException("cannot configure [" + this.softDeletesFieldName + "] as soft-deletes; this index uses [" + fieldName + "] as non-soft-deletes already");
            }
            return fieldNumber;
        }

        synchronized void verifyConsistent(Integer number, String name, IndexOptions indexOptions) {
            if (!name.equals(this.numberToName.get(number))) {
                throw new IllegalArgumentException("field number " + number + " is already mapped to field name \"" + this.numberToName.get(number) + "\", not \"" + name + "\"");
            }
            if (!number.equals(this.nameToNumber.get(name))) {
                throw new IllegalArgumentException("field name \"" + name + "\" is already mapped to field number \"" + this.nameToNumber.get(name) + "\", not \"" + number + "\"");
            }
            IndexOptions currentIndexOptions = this.indexOptions.get(name);
            if (indexOptions != IndexOptions.NONE && currentIndexOptions != null && currentIndexOptions != IndexOptions.NONE && indexOptions != currentIndexOptions) {
                throw new IllegalArgumentException("cannot change field \"" + name + "\" from index options=" + (Object)((Object)currentIndexOptions) + " to inconsistent index options=" + (Object)((Object)indexOptions));
            }
        }

        synchronized void verifyConsistent(Integer number, String name, DocValuesType dvType) {
            if (!name.equals(this.numberToName.get(number))) {
                throw new IllegalArgumentException("field number " + number + " is already mapped to field name \"" + this.numberToName.get(number) + "\", not \"" + name + "\"");
            }
            if (!number.equals(this.nameToNumber.get(name))) {
                throw new IllegalArgumentException("field name \"" + name + "\" is already mapped to field number \"" + this.nameToNumber.get(name) + "\", not \"" + number + "\"");
            }
            DocValuesType currentDVType = this.docValuesType.get(name);
            if (dvType != DocValuesType.NONE && currentDVType != null && currentDVType != DocValuesType.NONE && dvType != currentDVType) {
                throw new IllegalArgumentException("cannot change DocValues type from " + (Object)((Object)currentDVType) + " to " + (Object)((Object)dvType) + " for field \"" + name + "\"");
            }
        }

        synchronized void verifyConsistentDimensions(Integer number, String name, int dataDimensionCount, int indexDimensionCount, int dimensionNumBytes) {
            if (!name.equals(this.numberToName.get(number))) {
                throw new IllegalArgumentException("field number " + number + " is already mapped to field name \"" + this.numberToName.get(number) + "\", not \"" + name + "\"");
            }
            if (!number.equals(this.nameToNumber.get(name))) {
                throw new IllegalArgumentException("field name \"" + name + "\" is already mapped to field number \"" + this.nameToNumber.get(name) + "\", not \"" + number + "\"");
            }
            FieldDimensions dim = this.dimensions.get(name);
            if (dim != null) {
                if (dim.dimensionCount != dataDimensionCount) {
                    throw new IllegalArgumentException("cannot change point dimension count from " + dim.dimensionCount + " to " + dataDimensionCount + " for field=\"" + name + "\"");
                }
                if (dim.indexDimensionCount != indexDimensionCount) {
                    throw new IllegalArgumentException("cannot change point index dimension count from " + dim.indexDimensionCount + " to " + indexDimensionCount + " for field=\"" + name + "\"");
                }
                if (dim.dimensionNumBytes != dimensionNumBytes) {
                    throw new IllegalArgumentException("cannot change point numBytes from " + dim.dimensionNumBytes + " to " + dimensionNumBytes + " for field=\"" + name + "\"");
                }
            }
        }

        synchronized boolean contains(String fieldName, DocValuesType dvType) {
            if (!this.nameToNumber.containsKey(fieldName)) {
                return false;
            }
            return dvType == this.docValuesType.get(fieldName);
        }

        @Deprecated
        synchronized Set<String> getFieldNames() {
            return Collections.unmodifiableSet(new HashSet<String>(this.nameToNumber.keySet()));
        }

        synchronized void clear() {
            this.numberToName.clear();
            this.nameToNumber.clear();
            this.indexOptions.clear();
            this.docValuesType.clear();
            this.dimensions.clear();
        }

        synchronized void setIndexOptions(int number, String name, IndexOptions indexOptions) {
            this.verifyConsistent((Integer)number, name, indexOptions);
            this.indexOptions.put(name, indexOptions);
        }

        synchronized void setDocValuesType(int number, String name, DocValuesType dvType) {
            this.verifyConsistent((Integer)number, name, dvType);
            this.docValuesType.put(name, dvType);
        }

        synchronized void setDimensions(int number, String name, int dimensionCount, int indexDimensionCount, int dimensionNumBytes) {
            if (dimensionCount > 16) {
                throw new IllegalArgumentException("dimensionCount must be <= PointValues.MAX_DIMENSIONS (= 16); got " + dimensionCount + " for field=\"" + name + "\"");
            }
            if (dimensionNumBytes > 16) {
                throw new IllegalArgumentException("dimension numBytes must be <= PointValues.MAX_NUM_BYTES (= 16); got " + dimensionNumBytes + " for field=\"" + name + "\"");
            }
            if (indexDimensionCount > dimensionCount) {
                throw new IllegalArgumentException("indexDimensionCount must be <= dimensionCount (= " + dimensionCount + "); got " + indexDimensionCount + " for field=\"" + name + "\"");
            }
            if (indexDimensionCount > 8) {
                throw new IllegalArgumentException("indexDimensionCount must be <= PointValues.MAX_INDEX_DIMENSIONS (= 8); got " + indexDimensionCount + " for field=\"" + name + "\"");
            }
            this.verifyConsistentDimensions(number, name, dimensionCount, indexDimensionCount, dimensionNumBytes);
            this.dimensions.put(name, new FieldDimensions(dimensionCount, indexDimensionCount, dimensionNumBytes));
        }
    }

    static final class FieldDimensions {
        public final int dimensionCount;
        public final int indexDimensionCount;
        public final int dimensionNumBytes;

        public FieldDimensions(int dimensionCount, int indexDimensionCount, int dimensionNumBytes) {
            this.dimensionCount = dimensionCount;
            this.indexDimensionCount = indexDimensionCount;
            this.dimensionNumBytes = dimensionNumBytes;
        }
    }
}

