/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocValuesUpdate;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldUpdatesBuffer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Counter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.RamUsageEstimator;

class BufferedUpdates
implements Accountable {
    static final int BYTES_PER_DEL_TERM = 9 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 7 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 40;
    static final int BYTES_PER_DEL_QUERY = 5 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 2 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + 24;
    final AtomicInteger numTermDeletes = new AtomicInteger();
    final AtomicInteger numFieldUpdates = new AtomicInteger();
    final Map<Term, Integer> deleteTerms = new HashMap<Term, Integer>();
    final Map<Query, Integer> deleteQueries = new HashMap<Query, Integer>();
    final Map<String, FieldUpdatesBuffer> fieldUpdates = new HashMap<String, FieldUpdatesBuffer>();
    public static final Integer MAX_INT = Integer.MAX_VALUE;
    private final Counter bytesUsed = Counter.newCounter(true);
    final Counter fieldUpdatesBytesUsed = Counter.newCounter(true);
    private final Counter termsBytesUsed = Counter.newCounter(true);
    private static final boolean VERBOSE_DELETES = false;
    long gen;
    final String segmentName;

    public BufferedUpdates(String segmentName) {
        this.segmentName = segmentName;
    }

    public String toString() {
        String s2 = "gen=" + this.gen;
        if (this.numTermDeletes.get() != 0) {
            s2 = s2 + " " + this.numTermDeletes.get() + " deleted terms (unique count=" + this.deleteTerms.size() + ")";
        }
        if (this.deleteQueries.size() != 0) {
            s2 = s2 + " " + this.deleteQueries.size() + " deleted queries";
        }
        if (this.numFieldUpdates.get() != 0) {
            s2 = s2 + " " + this.numFieldUpdates.get() + " field updates";
        }
        if (this.bytesUsed.get() != 0L) {
            s2 = s2 + " bytesUsed=" + this.bytesUsed.get();
        }
        return s2;
    }

    public void addQuery(Query query, int docIDUpto) {
        Integer current = this.deleteQueries.put(query, docIDUpto);
        if (current == null) {
            this.bytesUsed.addAndGet(BYTES_PER_DEL_QUERY);
        }
    }

    public void addTerm(Term term, int docIDUpto) {
        Integer current = this.deleteTerms.get(term);
        if (current != null && docIDUpto < current) {
            return;
        }
        this.deleteTerms.put(term, docIDUpto);
        this.numTermDeletes.incrementAndGet();
        if (current == null) {
            this.termsBytesUsed.addAndGet(BYTES_PER_DEL_TERM + term.bytes.length + 2 * term.field().length());
        }
    }

    void addNumericUpdate(DocValuesUpdate.NumericDocValuesUpdate update, int docIDUpto) {
        FieldUpdatesBuffer buffer = this.fieldUpdates.computeIfAbsent(update.field, k -> new FieldUpdatesBuffer(this.fieldUpdatesBytesUsed, update, docIDUpto));
        if (update.hasValue) {
            buffer.addUpdate(update.term, update.getValue(), docIDUpto);
        } else {
            buffer.addNoValue(update.term, docIDUpto);
        }
        this.numFieldUpdates.incrementAndGet();
    }

    void addBinaryUpdate(DocValuesUpdate.BinaryDocValuesUpdate update, int docIDUpto) {
        FieldUpdatesBuffer buffer = this.fieldUpdates.computeIfAbsent(update.field, k -> new FieldUpdatesBuffer(this.fieldUpdatesBytesUsed, update, docIDUpto));
        if (update.hasValue) {
            buffer.addUpdate(update.term, update.getValue(), docIDUpto);
        } else {
            buffer.addNoValue(update.term, docIDUpto);
        }
        this.numFieldUpdates.incrementAndGet();
    }

    void clearDeleteTerms() {
        this.numTermDeletes.set(0);
        this.termsBytesUsed.addAndGet(-this.termsBytesUsed.get());
        this.deleteTerms.clear();
    }

    void clear() {
        this.deleteTerms.clear();
        this.deleteQueries.clear();
        this.numTermDeletes.set(0);
        this.numFieldUpdates.set(0);
        this.fieldUpdates.clear();
        this.bytesUsed.addAndGet(-this.bytesUsed.get());
        this.fieldUpdatesBytesUsed.addAndGet(-this.fieldUpdatesBytesUsed.get());
        this.termsBytesUsed.addAndGet(-this.termsBytesUsed.get());
    }

    boolean any() {
        return this.deleteTerms.size() > 0 || this.deleteQueries.size() > 0 || this.numFieldUpdates.get() > 0;
    }

    @Override
    public long ramBytesUsed() {
        return this.bytesUsed.get() + this.fieldUpdatesBytesUsed.get() + this.termsBytesUsed.get();
    }
}

