/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.NumericUtils;

public final class XYEncodingUtils {
    public static final double MIN_VAL_INCL = -3.4028234663852886E38;
    public static final double MAX_VAL_INCL = 3.4028234663852886E38;

    private XYEncodingUtils() {
    }

    static float checkVal(float x) {
        if (!Float.isFinite(x)) {
            throw new IllegalArgumentException("invalid value " + x + "; must be between " + -3.4028234663852886E38 + " and " + 3.4028234663852886E38);
        }
        return x;
    }

    public static int encode(float x) {
        return NumericUtils.floatToSortableInt(XYEncodingUtils.checkVal(x));
    }

    public static float decode(int encoded) {
        float result = NumericUtils.sortableIntToFloat(encoded);
        assert ((double)result >= -3.4028234663852886E38 && (double)result <= 3.4028234663852886E38);
        return result;
    }

    public static float decode(byte[] src, int offset) {
        return XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(src, offset));
    }

    static double[] floatArrayToDoubleArray(float[] f) {
        double[] d = new double[f.length];
        for (int i = 0; i < f.length; ++i) {
            d[i] = f[i];
        }
        return d;
    }
}

