/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.BinaryRangeFieldRangeQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.LongRange;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.RangeFieldQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.QueryVisitor;

class LongRangeSlowRangeQuery
extends BinaryRangeFieldRangeQuery {
    private final String field;
    private final long[] min;
    private final long[] max;

    LongRangeSlowRangeQuery(String field, long[] min2, long[] max, RangeFieldQuery.QueryType queryType) {
        super(field, LongRangeSlowRangeQuery.encodeRanges(min2, max), 8, min2.length, queryType);
        this.field = field;
        this.min = min2;
        this.max = max;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        LongRangeSlowRangeQuery that = (LongRangeSlowRangeQuery)obj;
        return Objects.equals(this.field, that.field) && Arrays.equals(this.min, that.min) && Arrays.equals(this.max, that.max);
    }

    @Override
    public int hashCode() {
        int h2 = this.classHash();
        h2 = 31 * h2 + this.field.hashCode();
        h2 = 31 * h2 + Arrays.hashCode(this.min);
        h2 = 31 * h2 + Arrays.hashCode(this.max);
        return h2;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(Arrays.toString(this.min)).append(" TO ").append(Arrays.toString(this.max)).append("]").toString();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        return super.rewrite(reader);
    }

    private static byte[] encodeRanges(long[] min2, long[] max) {
        byte[] result = new byte[16 * min2.length];
        LongRange.verifyAndEncode(min2, max, result);
        return result;
    }
}

