/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.BinaryRangeFieldRangeQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.FloatRange;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.RangeFieldQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.QueryVisitor;

class FloatRangeSlowRangeQuery
extends BinaryRangeFieldRangeQuery {
    private final String field;
    private final float[] min;
    private final float[] max;

    FloatRangeSlowRangeQuery(String field, float[] min2, float[] max, RangeFieldQuery.QueryType queryType) {
        super(field, FloatRangeSlowRangeQuery.encodeRanges(min2, max), 4, min2.length, queryType);
        this.field = field;
        this.min = min2;
        this.max = max;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        FloatRangeSlowRangeQuery that = (FloatRangeSlowRangeQuery)obj;
        return Objects.equals(this.field, that.field) && Arrays.equals(this.min, that.min) && Arrays.equals(this.max, that.max);
    }

    @Override
    public int hashCode() {
        int h2 = this.classHash();
        h2 = 31 * h2 + this.field.hashCode();
        h2 = 31 * h2 + Arrays.hashCode(this.min);
        h2 = 31 * h2 + Arrays.hashCode(this.max);
        return h2;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(Arrays.toString(this.min)).append(" TO ").append(Arrays.toString(this.max)).append("]").toString();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        return super.rewrite(reader);
    }

    private static byte[] encodeRanges(float[] min2, float[] max) {
        byte[] result = new byte[8 * min2.length];
        FloatRange.verifyAndEncode(min2, max, result);
        return result;
    }
}

