/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.BinaryRangeDocValuesField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.DoubleRange;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.DoubleRangeSlowRangeQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.RangeFieldQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;

public class DoubleRangeDocValuesField
extends BinaryRangeDocValuesField {
    final String field;
    final double[] min;
    final double[] max;

    public DoubleRangeDocValuesField(String field, double[] min2, double[] max) {
        super(field, DoubleRange.encode(min2, max), min2.length, 8);
        DoubleRangeDocValuesField.checkArgs(min2, max);
        this.field = field;
        this.min = min2;
        this.max = max;
    }

    public double getMin(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.min[dimension];
    }

    public double getMax(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.max[dimension];
    }

    private static Query newSlowRangeQuery(String field, double[] min2, double[] max, RangeFieldQuery.QueryType queryType) {
        DoubleRangeDocValuesField.checkArgs(min2, max);
        return new DoubleRangeSlowRangeQuery(field, min2, max, queryType);
    }

    public static Query newSlowIntersectsQuery(String field, double[] min2, double[] max) {
        return DoubleRangeDocValuesField.newSlowRangeQuery(field, min2, max, RangeFieldQuery.QueryType.INTERSECTS);
    }

    private static void checkArgs(double[] min2, double[] max) {
        if (min2 == null || max == null || min2.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min2.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        for (int i = 0; i < min2.length; ++i) {
            if (!(min2[i] > max[i])) continue;
            throw new IllegalArgumentException("min should be less than max");
        }
    }
}

