/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.lucene60;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocValuesType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SegmentInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ChecksumIndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexOutput;

public final class Lucene60FieldInfosFormat
extends FieldInfosFormat {
    static final String EXTENSION = "fnm";
    static final String CODEC_NAME = "Lucene60FieldInfos";
    static final int FORMAT_START = 0;
    static final int FORMAT_SOFT_DELETES = 1;
    static final int FORMAT_SELECTIVE_INDEXING = 2;
    static final int FORMAT_CURRENT = 2;
    static final byte STORE_TERMVECTOR = 1;
    static final byte OMIT_NORMS = 2;
    static final byte STORE_PAYLOADS = 4;
    static final byte SOFT_DELETES_FIELD = 8;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segmentInfo.name, segmentSuffix, EXTENSION);
        try (ChecksumIndexInput input = directory.openChecksumInput(fileName, context);){
            Throwable priorE = null;
            FieldInfo[] infos = null;
            try {
                int version = CodecUtil.checkIndexHeader(input, CODEC_NAME, 0, 2, segmentInfo.getId(), segmentSuffix);
                int size = input.readVInt();
                infos = new FieldInfo[size];
                Map<Object, Object> lastAttributes = Collections.emptyMap();
                for (int i = 0; i < size; ++i) {
                    int pointNumBytes;
                    int pointDataDimensionCount;
                    String name = input.readString();
                    int fieldNumber = input.readVInt();
                    if (fieldNumber < 0) {
                        throw new CorruptIndexException("invalid field number for field: " + name + ", fieldNumber=" + fieldNumber, input);
                    }
                    byte bits = input.readByte();
                    boolean storeTermVector = (bits & 1) != 0;
                    boolean omitNorms = (bits & 2) != 0;
                    boolean storePayloads = (bits & 4) != 0;
                    boolean isSoftDeletesField = (bits & 8) != 0;
                    IndexOptions indexOptions = Lucene60FieldInfosFormat.getIndexOptions(input, input.readByte());
                    DocValuesType docValuesType = Lucene60FieldInfosFormat.getDocValuesType(input, input.readByte());
                    long dvGen = input.readLong();
                    Map<String, String> attributes = input.readMapOfStrings();
                    if (attributes.equals(lastAttributes)) {
                        attributes = lastAttributes;
                    }
                    lastAttributes = attributes;
                    int pointIndexDimensionCount = pointDataDimensionCount = input.readVInt();
                    if (pointDataDimensionCount != 0) {
                        if (version >= 2) {
                            pointIndexDimensionCount = input.readVInt();
                        }
                        pointNumBytes = input.readVInt();
                    } else {
                        pointNumBytes = 0;
                    }
                    try {
                        infos[i] = new FieldInfo(name, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, dvGen, attributes, pointDataDimensionCount, pointIndexDimensionCount, pointNumBytes, isSoftDeletesField);
                        infos[i].checkConsistency();
                        continue;
                    }
                    catch (IllegalStateException e) {
                        throw new CorruptIndexException("invalid fieldinfo for field: " + name + ", fieldNumber=" + fieldNumber, input, (Throwable)e);
                    }
                }
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter(input, priorE);
            }
            FieldInfos fieldInfos = new FieldInfos(infos);
            return fieldInfos;
        }
    }

    private static byte docValuesByte(DocValuesType type) {
        switch (type) {
            case NONE: {
                return 0;
            }
            case NUMERIC: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case SORTED: {
                return 3;
            }
            case SORTED_SET: {
                return 4;
            }
            case SORTED_NUMERIC: {
                return 5;
            }
        }
        throw new AssertionError((Object)("unhandled DocValuesType: " + (Object)((Object)type)));
    }

    private static DocValuesType getDocValuesType(IndexInput input, byte b) throws IOException {
        switch (b) {
            case 0: {
                return DocValuesType.NONE;
            }
            case 1: {
                return DocValuesType.NUMERIC;
            }
            case 2: {
                return DocValuesType.BINARY;
            }
            case 3: {
                return DocValuesType.SORTED;
            }
            case 4: {
                return DocValuesType.SORTED_SET;
            }
            case 5: {
                return DocValuesType.SORTED_NUMERIC;
            }
        }
        throw new CorruptIndexException("invalid docvalues byte: " + b, input);
    }

    private static byte indexOptionsByte(IndexOptions indexOptions) {
        switch (indexOptions) {
            case NONE: {
                return 0;
            }
            case DOCS: {
                return 1;
            }
            case DOCS_AND_FREQS: {
                return 2;
            }
            case DOCS_AND_FREQS_AND_POSITIONS: {
                return 3;
            }
            case DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS: {
                return 4;
            }
        }
        throw new AssertionError((Object)("unhandled IndexOptions: " + (Object)((Object)indexOptions)));
    }

    private static IndexOptions getIndexOptions(IndexInput input, byte b) throws IOException {
        switch (b) {
            case 0: {
                return IndexOptions.NONE;
            }
            case 1: {
                return IndexOptions.DOCS;
            }
            case 2: {
                return IndexOptions.DOCS_AND_FREQS;
            }
            case 3: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            }
            case 4: {
                return IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
            }
        }
        throw new CorruptIndexException("invalid IndexOptions byte: " + b, input);
    }

    @Override
    public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segmentInfo.name, segmentSuffix, EXTENSION);
        try (IndexOutput output = directory.createOutput(fileName, context);){
            CodecUtil.writeIndexHeader(output, CODEC_NAME, 2, segmentInfo.getId(), segmentSuffix);
            output.writeVInt(infos.size());
            for (FieldInfo fi : infos) {
                fi.checkConsistency();
                output.writeString(fi.name);
                output.writeVInt(fi.number);
                byte bits = 0;
                if (fi.hasVectors()) {
                    bits = (byte)(bits | 1);
                }
                if (fi.omitsNorms()) {
                    bits = (byte)(bits | 2);
                }
                if (fi.hasPayloads()) {
                    bits = (byte)(bits | 4);
                }
                if (fi.isSoftDeletesField()) {
                    bits = (byte)(bits | 8);
                }
                output.writeByte(bits);
                output.writeByte(Lucene60FieldInfosFormat.indexOptionsByte(fi.getIndexOptions()));
                output.writeByte(Lucene60FieldInfosFormat.docValuesByte(fi.getDocValuesType()));
                output.writeLong(fi.getDocValuesGen());
                output.writeMapOfStrings(fi.attributes());
                output.writeVInt(fi.getPointDimensionCount());
                if (fi.getPointDimensionCount() == 0) continue;
                output.writeVInt(fi.getPointIndexDimensionCount());
                output.writeVInt(fi.getPointNumBytes());
            }
            CodecUtil.writeFooter(output);
        }
    }

    static {
        boolean bl = $assertionsDisabled = !Lucene60FieldInfosFormat.class.desiredAssertionStatus();
        if (!$assertionsDisabled && DocValuesType.values().length != 6) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && IndexOptions.values().length != 5) {
            throw new AssertionError();
        }
    }
}

