/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.pattern;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.charfilter.BaseCharFilter;

public class PatternReplaceCharFilter
extends BaseCharFilter {
    private final Pattern pattern;
    private final String replacement;
    private Reader transformedInput;

    public PatternReplaceCharFilter(Pattern pattern, String replacement, Reader in) {
        super(in);
        this.pattern = pattern;
        this.replacement = replacement;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.transformedInput == null) {
            this.fill();
        }
        return this.transformedInput.read(cbuf, off, len);
    }

    private void fill() throws IOException {
        StringBuilder buffered = new StringBuilder();
        char[] temp = new char[1024];
        int cnt = this.input.read(temp);
        while (cnt > 0) {
            buffered.append(temp, 0, cnt);
            cnt = this.input.read(temp);
        }
        this.transformedInput = new StringReader(this.processPattern(buffered).toString());
    }

    @Override
    public int read() throws IOException {
        if (this.transformedInput == null) {
            this.fill();
        }
        return this.transformedInput.read();
    }

    @Override
    protected int correct(int currentOff) {
        return Math.max(0, super.correct(currentOff));
    }

    CharSequence processPattern(CharSequence input) {
        Matcher m3 = this.pattern.matcher(input);
        StringBuffer cumulativeOutput = new StringBuffer();
        int cumulative = 0;
        int lastMatchEnd = 0;
        while (m3.find()) {
            int groupSize = m3.end() - m3.start();
            int skippedSize = m3.start() - lastMatchEnd;
            lastMatchEnd = m3.end();
            int lengthBeforeReplacement = cumulativeOutput.length() + skippedSize;
            m3.appendReplacement(cumulativeOutput, this.replacement);
            int replacementSize = cumulativeOutput.length() - lengthBeforeReplacement;
            if (groupSize == replacementSize) continue;
            if (replacementSize < groupSize) {
                int atIndex = lengthBeforeReplacement + replacementSize;
                this.addOffCorrectMap(atIndex, cumulative += groupSize - replacementSize);
                continue;
            }
            for (int i = groupSize; i < replacementSize; ++i) {
                this.addOffCorrectMap(lengthBeforeReplacement + i, --cumulative);
            }
        }
        m3.appendTail(cumulativeOutput);
        return cumulativeOutput;
    }
}

