/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.no;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.util.StemmerUtil;

public class NorwegianMinimalStemmer {
    final boolean useBokmaal;
    final boolean useNynorsk;

    public NorwegianMinimalStemmer(int flags) {
        if (flags <= 0 || flags > 3) {
            throw new IllegalArgumentException("invalid flags");
        }
        this.useBokmaal = (flags & 1) != 0;
        this.useNynorsk = (flags & 2) != 0;
    }

    public int stem(char[] s2, int len) {
        if (len > 4 && s2[len - 1] == 's') {
            --len;
        }
        if (len > 5 && (StemmerUtil.endsWith(s2, len, "ene") || StemmerUtil.endsWith(s2, len, "ane") && this.useNynorsk)) {
            return len - 3;
        }
        if (len > 4 && (StemmerUtil.endsWith(s2, len, "er") || StemmerUtil.endsWith(s2, len, "en") || StemmerUtil.endsWith(s2, len, "et") || StemmerUtil.endsWith(s2, len, "ar") && this.useNynorsk)) {
            return len - 2;
        }
        if (len > 3) {
            switch (s2[len - 1]) {
                case 'a': 
                case 'e': {
                    return len - 1;
                }
            }
        }
        return len;
    }
}

