/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.ngram;

import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.util.TokenFilterFactory;

public class NGramFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "nGram";
    private final int maxGramSize;
    private final int minGramSize;
    private final boolean preserveOriginal;

    public NGramFilterFactory(Map<String, String> args) {
        super(args);
        this.minGramSize = this.requireInt(args, "minGramSize");
        this.maxGramSize = this.requireInt(args, "maxGramSize");
        boolean preserve = this.getBoolean(args, "keepShortTerm", false);
        this.preserveOriginal = this.getBoolean(args, "preserveOriginal", preserve);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TokenFilter create(TokenStream input) {
        return new NGramTokenFilter(input, this.minGramSize, this.maxGramSize, this.preserveOriginal);
    }
}

