/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.charfilter;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.charfilter.MappingCharFilter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.charfilter.NormalizeCharMap;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.util.ResourceLoaderAware;

public class MappingCharFilterFactory
extends CharFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "mapping";
    protected NormalizeCharMap normMap;
    private final String mapping;
    static Pattern p = Pattern.compile("\"(.*)\"\\s*=>\\s*\"(.*)\"\\s*$");
    char[] out = new char[256];

    public MappingCharFilterFactory(Map<String, String> args) {
        super(args);
        this.mapping = this.get(args, NAME);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        if (this.mapping != null) {
            ArrayList<String> wlist = null;
            List<String> files = this.splitFileNames(this.mapping);
            wlist = new ArrayList<String>();
            for (String file : files) {
                List<String> lines = this.getLines(loader, file.trim());
                wlist.addAll(lines);
            }
            NormalizeCharMap.Builder builder = new NormalizeCharMap.Builder();
            this.parseRules(wlist, builder);
            this.normMap = builder.build();
            if (this.normMap.map == null) {
                this.normMap = null;
            }
        }
    }

    @Override
    public Reader create(Reader input) {
        return this.normMap == null ? input : new MappingCharFilter(this.normMap, input);
    }

    @Override
    public Reader normalize(Reader input) {
        return this.create(input);
    }

    protected void parseRules(List<String> rules, NormalizeCharMap.Builder builder) {
        for (String rule : rules) {
            Matcher m3 = p.matcher(rule);
            if (!m3.find()) {
                throw new IllegalArgumentException("Invalid Mapping Rule : [" + rule + "], file = " + this.mapping);
            }
            builder.add(this.parseString(m3.group(1)), this.parseString(m3.group(2)));
        }
    }

    protected String parseString(String s2) {
        int readPos = 0;
        int len = s2.length();
        int writePos = 0;
        while (readPos < len) {
            int c;
            if ((c = s2.charAt(readPos++)) == 92) {
                if (readPos >= len) {
                    throw new IllegalArgumentException("Invalid escaped char in [" + s2 + "]");
                }
                c = s2.charAt(readPos++);
                switch (c) {
                    case 92: {
                        c = 92;
                        break;
                    }
                    case 34: {
                        c = 34;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 117: {
                        if (readPos + 3 >= len) {
                            throw new IllegalArgumentException("Invalid escaped char in [" + s2 + "]");
                        }
                        c = (char)Integer.parseInt(s2.substring(readPos, readPos + 4), 16);
                        readPos += 4;
                    }
                }
            }
            this.out[writePos++] = c;
        }
        return new String(this.out, 0, writePos);
    }
}

