/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;

class GenericAuthorizer
implements Authorizer {
    private static final int NO_ACCESS = 0;
    private static final int READ_ACCESS = 1;
    private static final int FULL_ACCESS = 2;
    private int userAccessLevel;
    boolean readOnlyConnection;
    private final LanguageConnectionContext lcc;

    GenericAuthorizer(LanguageConnectionContext languageConnectionContext) throws StandardException {
        this.lcc = languageConnectionContext;
        this.refresh();
    }

    private boolean connectionMustRemainReadOnly() {
        return this.lcc.getDatabase().isReadOnly() || this.userAccessLevel == 1;
    }

    @Override
    public void authorize(int n) throws StandardException {
        this.authorize((Activation)null, n);
    }

    @Override
    public void authorize(Activation activation, int n) throws StandardException {
        short s2 = this.lcc.getStatementContext().getSQLAllowed();
        switch (n) {
            case 2: 
            case 3: {
                if (s2 != 3) break;
                throw GenericAuthorizer.externalRoutineException(n, s2);
            }
            case 1: {
                if (s2 <= 1) break;
                throw GenericAuthorizer.externalRoutineException(n, s2);
            }
            case 0: 
            case 5: {
                if (this.isReadOnlyConnection()) {
                    throw StandardException.newException("25502", new Object[0]);
                }
                if (s2 <= 0) break;
                throw GenericAuthorizer.externalRoutineException(n, s2);
            }
            case 4: 
            case 6: {
                if (this.isReadOnlyConnection()) {
                    throw StandardException.newException("25503", new Object[0]);
                }
                if (s2 <= 0) break;
                throw GenericAuthorizer.externalRoutineException(n, s2);
            }
        }
        if (activation != null) {
            List<StatementPermission> list = activation.getPreparedStatement().getRequiredPermissionsList();
            this.authorize(list, activation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authorize(List<StatementPermission> list, Activation activation) throws StandardException {
        DataDictionary dataDictionary = this.lcc.getDataDictionary();
        if (list != null && !list.isEmpty() && !this.lcc.getCurrentUserId(activation).equals(dataDictionary.getAuthorizationDatabaseOwner())) {
            int n = dataDictionary.startReading(this.lcc);
            this.lcc.beginNestedTransaction(true);
            try {
                try {
                    for (StatementPermission statementPermission : list) {
                        statementPermission.check(this.lcc, false, activation);
                    }
                }
                finally {
                    dataDictionary.doneReading(n, this.lcc);
                }
            }
            finally {
                this.lcc.commitNestedTransaction();
            }
        }
    }

    private static StandardException externalRoutineException(int n, int n2) {
        String string;
        if (n2 == 1) {
            string = "38002";
        } else if (n2 == 2) {
            switch (n) {
                case 0: 
                case 4: 
                case 5: 
                case 6: {
                    string = "38002";
                    break;
                }
                default: {
                    string = "38004";
                    break;
                }
            }
        } else {
            string = "38001";
        }
        return StandardException.newException(string, new Object[0]);
    }

    private void getUserAccessLevel() throws StandardException {
        this.userAccessLevel = 0;
        if (this.userOnAccessList("derby.database.fullAccessUsers")) {
            this.userAccessLevel = 2;
        }
        if (this.userAccessLevel == 0 && this.userOnAccessList("derby.database.readOnlyAccessUsers")) {
            this.userAccessLevel = 1;
        }
        if (this.userAccessLevel == 0) {
            this.userAccessLevel = this.getDefaultAccessLevel();
        }
    }

    private int getDefaultAccessLevel() throws StandardException {
        TransactionController transactionController = this.lcc.getTransactionExecute();
        String string = PropertyUtil.getServiceProperty(transactionController, "derby.database.defaultConnectionMode");
        if (string == null) {
            return 2;
        }
        if (StringUtil.SQLEqualsIgnoreCase(string, "NOACCESS")) {
            return 0;
        }
        if (StringUtil.SQLEqualsIgnoreCase(string, "READONLYACCESS")) {
            return 1;
        }
        if (StringUtil.SQLEqualsIgnoreCase(string, "FULLACCESS")) {
            return 2;
        }
        return 2;
    }

    private boolean userOnAccessList(String string) throws StandardException {
        TransactionController transactionController = this.lcc.getTransactionExecute();
        String string2 = PropertyUtil.getServiceProperty(transactionController, string);
        return IdUtil.idOnList(this.lcc.getSessionUserId(), string2);
    }

    @Override
    public boolean isReadOnlyConnection() {
        return this.readOnlyConnection;
    }

    @Override
    public void setReadOnlyConnection(boolean bl, boolean bl2) throws StandardException {
        if (bl2 && !bl && this.connectionMustRemainReadOnly()) {
            throw StandardException.newException("25505", new Object[0]);
        }
        this.readOnlyConnection = bl;
    }

    @Override
    public final void refresh() throws StandardException {
        this.getUserAccessLevel();
        if (!this.readOnlyConnection) {
            this.readOnlyConnection = this.connectionMustRemainReadOnly();
        }
        if (this.userAccessLevel == 0) {
            throw StandardException.newException("08004.C.3", new Object[0]);
        }
    }
}

