/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.pulsar.table;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.connectors.pulsar.config.StartupMode;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarSinkSemantic;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarTableOptions;
import org.apache.flink.streaming.connectors.pulsar.util.KeyHashMessageRouterImpl;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.Format;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.inlong.sort.pulsar.table.Constants;
import org.apache.inlong.sort.pulsar.table.PulsarDynamicTableSink;
import org.apache.inlong.sort.pulsar.table.PulsarDynamicTableSource;

public class UpsertPulsarDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "upsert-pulsar-inlong";

    private static void validateTableOptions(ReadableConfig tableOptions, Format keyFormat, Format valueFormat, TableSchema schema) {
        UpsertPulsarDynamicTableFactory.validateTopic(tableOptions);
        UpsertPulsarDynamicTableFactory.validateFormat(keyFormat, valueFormat, tableOptions);
        UpsertPulsarDynamicTableFactory.validatePKConstraints(schema);
    }

    private static void validateTopic(ReadableConfig tableOptions) {
        List topic = (List)tableOptions.get(PulsarTableOptions.TOPIC);
        if (topic.size() > 1) {
            throw new ValidationException("The 'upsert-pulsar' connector doesn't support topic list now. Please use single topic as the value of the parameter 'topic'.");
        }
    }

    private static void validateFormat(Format keyFormat, Format valueFormat, ReadableConfig tableOptions) {
        if (!keyFormat.getChangelogMode().containsOnly(RowKind.INSERT)) {
            String identifier = (String)tableOptions.get(PulsarTableOptions.KEY_FORMAT);
            throw new ValidationException(String.format("'upsert-pulsar' connector doesn't support '%s' as key format, because '%s' is not in insert-only mode.", identifier, identifier));
        }
        if (!valueFormat.getChangelogMode().containsOnly(RowKind.INSERT)) {
            String identifier = (String)tableOptions.get(PulsarTableOptions.VALUE_FORMAT);
            throw new ValidationException(String.format("'upsert-Pulsar' connector doesn't support '%s' as value format, because '%s' is not in insert-only mode.", identifier, identifier));
        }
    }

    private static void validatePKConstraints(TableSchema schema) {
        if (!schema.getPrimaryKey().isPresent()) {
            throw new ValidationException("'upsert-pulsar' tables require to define a PRIMARY KEY constraint. The PRIMARY KEY specifies which columns should be read from or write to the Pulsar message key. The PRIMARY KEY also defines records in the 'upsert-pulsar' table should update or delete on which keys.");
        }
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(PulsarTableOptions.SERVICE_URL);
        options.add(PulsarTableOptions.TOPIC);
        options.add(PulsarTableOptions.KEY_FORMAT);
        options.add(PulsarTableOptions.VALUE_FORMAT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(PulsarTableOptions.ADMIN_URL);
        options.add(PulsarTableOptions.KEY_FIELDS_PREFIX);
        options.add(PulsarTableOptions.VALUE_FIELDS_INCLUDE);
        options.add(FactoryUtil.SINK_PARALLELISM);
        options.add(PulsarTableOptions.PROPERTIES);
        options.add(Constants.INLONG_METRIC);
        return options;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        DecodingFormat keyDecodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, PulsarTableOptions.KEY_FORMAT);
        DecodingFormat valueDecodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, PulsarTableOptions.VALUE_FORMAT);
        String valueFormatPrefix = (String)tableOptions.getOptional(FactoryUtil.FORMAT).orElse(tableOptions.get(PulsarTableOptions.VALUE_FORMAT));
        helper.validateExcept(new String[]{"properties.", valueFormatPrefix});
        TableSchema schema = context.getCatalogTable().getSchema();
        UpsertPulsarDynamicTableFactory.validateTableOptions(tableOptions, (Format)keyDecodingFormat, (Format)valueDecodingFormat, schema);
        Tuple2<int[], int[]> keyValueProjections = this.createKeyValueProjections((CatalogTable)context.getCatalogTable());
        String keyPrefix = tableOptions.getOptional(PulsarTableOptions.KEY_FIELDS_PREFIX).orElse(null);
        Properties properties = PulsarTableOptions.getPulsarProperties(context.getCatalogTable().toProperties());
        PulsarTableOptions.StartupOptions startupOptions = new PulsarTableOptions.StartupOptions();
        startupOptions.startupMode = StartupMode.EARLIEST;
        startupOptions.specificOffsets = Collections.EMPTY_MAP;
        String adminUrl = (String)tableOptions.get(PulsarTableOptions.ADMIN_URL);
        String serverUrl = (String)tableOptions.get(PulsarTableOptions.SERVICE_URL);
        List topics = (List)tableOptions.get(PulsarTableOptions.TOPIC);
        String topicPattern = (String)tableOptions.get(PulsarTableOptions.TOPIC_PATTERN);
        String inlongMetric = (String)tableOptions.get(Constants.INLONG_METRIC);
        String auditHostAndPorts = (String)tableOptions.get(org.apache.inlong.sort.base.Constants.INLONG_AUDIT);
        return new PulsarDynamicTableSource(schema.toPhysicalRowDataType(), (DecodingFormat<DeserializationSchema<RowData>>)keyDecodingFormat, new DecodingFormatWrapper((DecodingFormat<DeserializationSchema<RowData>>)valueDecodingFormat), (int[])keyValueProjections.f0, (int[])keyValueProjections.f1, keyPrefix, topics, topicPattern, serverUrl, adminUrl, properties, startupOptions, true, inlongMetric, auditHostAndPorts);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        EncodingFormat keyEncodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, PulsarTableOptions.KEY_FORMAT);
        EncodingFormat valueEncodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, PulsarTableOptions.VALUE_FORMAT);
        helper.validateExcept(new String[]{"properties."});
        TableSchema schema = context.getCatalogTable().getSchema();
        UpsertPulsarDynamicTableFactory.validateTableOptions(tableOptions, (Format)keyEncodingFormat, (Format)valueEncodingFormat, schema);
        Tuple2<int[], int[]> keyValueProjections = this.createKeyValueProjections((CatalogTable)context.getCatalogTable());
        String keyPrefix = tableOptions.getOptional(PulsarTableOptions.KEY_FIELDS_PREFIX).orElse(null);
        Properties properties = PulsarTableOptions.getPulsarProperties(context.getCatalogTable().toProperties());
        Integer parallelism = (Integer)tableOptions.get(FactoryUtil.SINK_PARALLELISM);
        String adminUrl = (String)tableOptions.get(PulsarTableOptions.ADMIN_URL);
        String serverUrl = (String)tableOptions.get(PulsarTableOptions.SERVICE_URL);
        String formatType = tableOptions.getOptional(FactoryUtil.FORMAT).orElseGet(() -> (String)tableOptions.get(PulsarTableOptions.VALUE_FORMAT));
        return new PulsarDynamicTableSink(serverUrl, adminUrl, (String)((List)tableOptions.get(PulsarTableOptions.TOPIC)).get(0), schema.toPhysicalRowDataType(), properties, (EncodingFormat<SerializationSchema<RowData>>)keyEncodingFormat, new EncodingFormatWrapper((EncodingFormat<SerializationSchema<RowData>>)valueEncodingFormat), (int[])keyValueProjections.f0, (int[])keyValueProjections.f1, keyPrefix, PulsarSinkSemantic.AT_LEAST_ONCE, formatType, true, parallelism, KeyHashMessageRouterImpl.INSTANCE);
    }

    private Tuple2<int[], int[]> createKeyValueProjections(CatalogTable catalogTable) {
        TableSchema schema = catalogTable.getSchema();
        List keyFields = ((UniqueConstraint)schema.getPrimaryKey().get()).getColumns();
        DataType physicalDataType = schema.toPhysicalRowDataType();
        Configuration tableOptions = Configuration.fromMap((Map)catalogTable.getOptions());
        tableOptions.set(PulsarTableOptions.KEY_FIELDS, (Object)keyFields);
        int[] keyProjection = PulsarTableOptions.createKeyFormatProjection((ReadableConfig)tableOptions, physicalDataType);
        int[] valueProjection = PulsarTableOptions.createValueFormatProjection((ReadableConfig)tableOptions, physicalDataType);
        return Tuple2.of((Object)keyProjection, (Object)valueProjection);
    }

    protected static class EncodingFormatWrapper
    implements EncodingFormat<SerializationSchema<RowData>> {
        public static final ChangelogMode SINK_CHANGELOG_MODE = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
        private final EncodingFormat<SerializationSchema<RowData>> innerEncodingFormat;

        public EncodingFormatWrapper(EncodingFormat<SerializationSchema<RowData>> innerEncodingFormat) {
            this.innerEncodingFormat = innerEncodingFormat;
        }

        public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
            return (SerializationSchema)this.innerEncodingFormat.createRuntimeEncoder(context, consumedDataType);
        }

        public ChangelogMode getChangelogMode() {
            return SINK_CHANGELOG_MODE;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EncodingFormatWrapper that = (EncodingFormatWrapper)obj;
            return Objects.equals(this.innerEncodingFormat, that.innerEncodingFormat);
        }

        public int hashCode() {
            return Objects.hash(this.innerEncodingFormat);
        }
    }

    protected static class DecodingFormatWrapper
    implements DecodingFormat<DeserializationSchema<RowData>> {
        private static final ChangelogMode SOURCE_CHANGELOG_MODE = ChangelogMode.newBuilder().addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
        private final DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat;

        public DecodingFormatWrapper(DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat) {
            this.innerDecodingFormat = innerDecodingFormat;
        }

        public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType) {
            return (DeserializationSchema)this.innerDecodingFormat.createRuntimeDecoder(context, producedDataType);
        }

        public ChangelogMode getChangelogMode() {
            return SOURCE_CHANGELOG_MODE;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DecodingFormatWrapper that = (DecodingFormatWrapper)obj;
            return Objects.equals(this.innerDecodingFormat, that.innerDecodingFormat);
        }

        public int hashCode() {
            return Objects.hash(this.innerDecodingFormat);
        }
    }
}

