/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.pulsar.table;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.util.serialization.FlinkSchema;
import org.apache.flink.streaming.util.serialization.PulsarDeserializationSchema;
import org.apache.flink.streaming.util.serialization.ThreadSafeDeserializationSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.DeserializationException;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.audit.AuditImp;
import org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.base.metric.SourceMetricData;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;

class DynamicPulsarDeserializationSchema
implements PulsarDeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<SimpleCollector<RowData>> tlsCollector = new ThreadLocal<SimpleCollector<RowData>>(){

        @Override
        public SimpleCollector initialValue() {
            return new SimpleCollector();
        }
    };
    @Nullable
    private final DeserializationSchema<RowData> keyDeserialization;
    private final DeserializationSchema<RowData> valueDeserialization;
    private final boolean hasMetadata;
    private final OutputProjectionCollector outputCollector;
    private final TypeInformation<RowData> producedTypeInfo;
    private final boolean upsertMode;
    private SourceMetricData sourceMetricData;
    private String inlongMetric;
    private String auditHostAndPorts;
    private AuditImp auditImp;
    private String inlongGroupId;
    private String inlongStreamId;

    DynamicPulsarDeserializationSchema(int physicalArity, @Nullable DeserializationSchema<RowData> keyDeserialization, int[] keyProjection, DeserializationSchema<RowData> valueDeserialization, int[] valueProjection, boolean hasMetadata, MetadataConverter[] metadataConverters, TypeInformation<RowData> producedTypeInfo, boolean upsertMode, String inlongMetric, String auditHostAndPorts) {
        if (upsertMode) {
            Preconditions.checkArgument((keyDeserialization != null && keyProjection.length > 0 ? 1 : 0) != 0, (Object)"Key must be set in upsert mode for deserialization schema.");
        }
        this.keyDeserialization = ThreadSafeDeserializationSchema.of(keyDeserialization);
        this.valueDeserialization = ThreadSafeDeserializationSchema.of(valueDeserialization);
        this.hasMetadata = hasMetadata;
        this.outputCollector = new OutputProjectionCollector(physicalArity, keyProjection, valueProjection, metadataConverters, upsertMode);
        this.producedTypeInfo = producedTypeInfo;
        this.upsertMode = upsertMode;
        this.inlongMetric = inlongMetric;
        this.auditHostAndPorts = auditHostAndPorts;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        if (this.keyDeserialization != null) {
            this.keyDeserialization.open(context);
        }
        this.valueDeserialization.open(context);
        if (this.inlongMetric != null && !this.inlongMetric.isEmpty()) {
            String[] inlongMetricArray = this.inlongMetric.split("&");
            this.inlongGroupId = inlongMetricArray[0];
            this.inlongStreamId = inlongMetricArray[1];
            String nodeId = inlongMetricArray[2];
            this.sourceMetricData = new SourceMetricData(this.inlongGroupId, this.inlongStreamId, nodeId, context.getMetricGroup());
            this.sourceMetricData.registerMetricsForNumBytesIn();
            this.sourceMetricData.registerMetricsForNumBytesInPerSecond();
            this.sourceMetricData.registerMetricsForNumRecordsIn();
            this.sourceMetricData.registerMetricsForNumRecordsInPerSecond();
        }
        if (this.auditHostAndPorts != null) {
            AuditImp.getInstance().setAuditProxy(new HashSet<String>(Arrays.asList(this.auditHostAndPorts.split("&"))));
            this.auditImp = AuditImp.getInstance();
        }
    }

    @Override
    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    @Override
    public RowData deserialize(Message<RowData> message) throws IOException {
        SimpleCollector<RowData> collector = tlsCollector.get();
        this.deserialize(message, (Collector<RowData>)collector);
        return (RowData)((SimpleCollector)collector).takeRecord();
    }

    @Override
    public void deserialize(Message<RowData> message, Collector<RowData> collector) throws IOException {
        if (this.keyDeserialization == null && !this.hasMetadata) {
            this.valueDeserialization.deserialize(message.getData(), collector);
            this.outputMetrics(message);
            return;
        }
        BufferingCollector keyCollector = new BufferingCollector();
        if (this.keyDeserialization != null) {
            this.keyDeserialization.deserialize(message.getKeyBytes(), (Collector)keyCollector);
        }
        this.outputCollector.inputMessage = message;
        this.outputCollector.physicalKeyRows = keyCollector.buffer;
        this.outputCollector.outputCollector = collector;
        if ((message.getData() == null || message.getData().length == 0) && this.upsertMode) {
            this.outputCollector.collect(null);
        } else {
            this.valueDeserialization.deserialize(message.getData(), (Collector)this.outputCollector);
            this.outputMetrics(message);
        }
        keyCollector.buffer.clear();
    }

    private void outputMetrics(Message<RowData> message) {
        if (this.sourceMetricData != null) {
            this.sourceMetricData.getNumRecordsIn().inc(1L);
            this.sourceMetricData.getNumBytesIn().inc((long)message.getData().length);
        }
        if (this.auditImp != null) {
            this.auditImp.add(Constants.AUDIT_SORT_INPUT, this.inlongGroupId, this.inlongStreamId, System.currentTimeMillis(), 1L, message.getData().length);
        }
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    @Override
    public Schema<RowData> getSchema() {
        return new FlinkSchema<RowData>(Schema.BYTES.getSchemaInfo(), null, this.valueDeserialization);
    }

    private static final class OutputProjectionCollector
    implements Collector<RowData>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int physicalArity;
        private final int[] keyProjection;
        private final int[] valueProjection;
        private final MetadataConverter[] metadataConverters;
        private final boolean upsertMode;
        private transient Message<?> inputMessage;
        private transient List<RowData> physicalKeyRows;
        private transient Collector<RowData> outputCollector;

        OutputProjectionCollector(int physicalArity, int[] keyProjection, int[] valueProjection, MetadataConverter[] metadataConverters, boolean upsertMode) {
            this.physicalArity = physicalArity;
            this.keyProjection = keyProjection;
            this.valueProjection = valueProjection;
            this.metadataConverters = metadataConverters;
            this.upsertMode = upsertMode;
        }

        public void collect(RowData physicalValueRow) {
            if (this.keyProjection.length == 0) {
                this.emitRow(null, (GenericRowData)physicalValueRow);
                return;
            }
            for (RowData physicalKeyRow : this.physicalKeyRows) {
                this.emitRow((GenericRowData)physicalKeyRow, (GenericRowData)physicalValueRow);
            }
        }

        public void close() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void emitRow(@Nullable GenericRowData physicalKeyRow, @Nullable GenericRowData physicalValueRow) {
            RowKind rowKind;
            if (physicalValueRow == null) {
                if (!this.upsertMode) throw new DeserializationException("Invalid null value received in non-upsert mode. Could not to set row kind for output record.");
                rowKind = RowKind.DELETE;
            } else {
                rowKind = physicalValueRow.getRowKind();
            }
            int metadataArity = this.metadataConverters.length;
            GenericRowData producedRow = new GenericRowData(rowKind, this.physicalArity + metadataArity);
            if (physicalValueRow != null) {
                for (int valuePos = 0; valuePos < this.valueProjection.length; ++valuePos) {
                    producedRow.setField(this.valueProjection[valuePos], physicalValueRow.getField(valuePos));
                }
            }
            for (int keyPos = 0; keyPos < this.keyProjection.length; ++keyPos) {
                assert (physicalKeyRow != null);
                producedRow.setField(this.keyProjection[keyPos], physicalKeyRow.getField(keyPos));
            }
            for (int metadataPos = 0; metadataPos < metadataArity; ++metadataPos) {
                producedRow.setField(this.physicalArity + metadataPos, this.metadataConverters[metadataPos].read(this.inputMessage));
            }
            this.outputCollector.collect((Object)producedRow);
        }
    }

    private static class SimpleCollector<T>
    implements Collector<T> {
        private T record;

        private SimpleCollector() {
        }

        public void collect(T record) {
            this.record = record;
        }

        public void close() {
        }

        private T getRecord() {
            return this.record;
        }

        private T takeRecord() {
            T result = this.record;
            this.reset();
            return result;
        }

        private void reset() {
            this.record = null;
        }
    }

    private static final class BufferingCollector
    implements Collector<RowData>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<RowData> buffer = new ArrayList<RowData>();

        private BufferingCollector() {
        }

        public void collect(RowData record) {
            this.buffer.add(record);
        }

        public void close() {
        }
    }

    static interface MetadataConverter
    extends Serializable {
        public Object read(Message<?> var1);
    }
}

