/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import com.google.protobuf.Descriptors;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarOptions;
import org.apache.flink.streaming.connectors.pulsar.internal.SchemaTranslator;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableList;
import org.apache.pulsar.shade.org.apache.avro.LogicalTypes;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.SchemaBuilder;

public class SimpleSchemaTranslator
extends SchemaTranslator {
    private final boolean useExtendField;
    private static final Schema NULL_SCHEMA = Schema.create(Schema.Type.NULL);
    private static int[] minBytesForPrecision = new int[39];
    public static final List<DataTypes.Field> METADATA_FIELDS;

    public SimpleSchemaTranslator() {
        this.useExtendField = false;
    }

    public SimpleSchemaTranslator(boolean useExtendField) {
        this.useExtendField = useExtendField;
    }

    @Override
    public SchemaInfo tableSchemaToPulsarSchema(TableSchema tableSchema) throws IncompatibleSchemaException {
        DataType dataType;
        ArrayList<String> fieldsRemaining = new ArrayList<String>(tableSchema.getFieldCount());
        for (String fieldName : tableSchema.getFieldNames()) {
            if (PulsarOptions.META_FIELD_NAMES.contains(fieldName)) continue;
            fieldsRemaining.add(fieldName);
        }
        if (fieldsRemaining.size() == 1) {
            dataType = (DataType)tableSchema.getFieldDataType((String)fieldsRemaining.get(0)).get();
        } else {
            List<DataTypes.Field> fieldList = fieldsRemaining.stream().map(f -> DataTypes.FIELD((String)f, (DataType)((DataType)tableSchema.getFieldDataType(f).get()))).collect(Collectors.toList());
            dataType = DataTypes.ROW((DataTypes.Field[])fieldList.toArray(new DataTypes.Field[0]));
        }
        return SimpleSchemaTranslator.sqlType2PulsarSchema(dataType).getSchemaInfo();
    }

    public static org.apache.pulsar.client.api.Schema sqlType2PulsarSchema(DataType flinkType) throws IncompatibleSchemaException {
        if (flinkType instanceof AtomicDataType) {
            return SimpleSchemaTranslator.atomicType2PulsarSchema(flinkType);
        }
        if (flinkType instanceof FieldsDataType) {
            return SimpleSchemaTranslator.avroSchema2PulsarSchema(SimpleSchemaTranslator.sqlType2AvroSchema(flinkType));
        }
        throw new IncompatibleSchemaException(String.format("%s is not supported by Pulsar yet", flinkType.toString()), null);
    }

    static GenericSchema<GenericRecord> avroSchema2PulsarSchema(Schema avroSchema) {
        byte[] schemaBytes = avroSchema.toString().getBytes(StandardCharsets.UTF_8);
        SchemaInfoImpl si = new SchemaInfoImpl();
        si.setName("Avro");
        si.setSchema(schemaBytes);
        si.setType(SchemaType.AVRO);
        return org.apache.pulsar.client.api.Schema.generic(si);
    }

    public static Schema sqlType2AvroSchema(DataType flinkType) throws IncompatibleSchemaException {
        return SimpleSchemaTranslator.sqlType2AvroSchema(flinkType, false, "record", "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Schema sqlType2AvroSchema(DataType flinkType, boolean nullable, String recordName, String namespace) throws IncompatibleSchemaException {
        Schema schema;
        block19: {
            LogicalTypeRoot type;
            SchemaBuilder.TypeBuilder<Schema> builder;
            block18: {
                builder = SchemaBuilder.builder();
                type = flinkType.getLogicalType().getTypeRoot();
                schema = null;
                if (!(flinkType instanceof AtomicDataType)) break block18;
                switch (type) {
                    case BOOLEAN: {
                        schema = (Schema)builder.booleanType();
                        break block19;
                    }
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: {
                        schema = (Schema)builder.intType();
                        break block19;
                    }
                    case BIGINT: {
                        schema = (Schema)builder.longType();
                        break block19;
                    }
                    case DATE: {
                        schema = LogicalTypes.date().addToSchema((Schema)builder.intType());
                        break block19;
                    }
                    case TIMESTAMP_WITHOUT_TIME_ZONE: {
                        schema = LogicalTypes.timestampMicros().addToSchema((Schema)builder.longType());
                        break block19;
                    }
                    case FLOAT: {
                        schema = (Schema)builder.floatType();
                        break block19;
                    }
                    case DOUBLE: {
                        schema = (Schema)builder.doubleType();
                        break block19;
                    }
                    case VARCHAR: {
                        schema = (Schema)builder.stringType();
                        break block19;
                    }
                    case BINARY: 
                    case VARBINARY: {
                        schema = (Schema)builder.bytesType();
                        break block19;
                    }
                    case DECIMAL: {
                        DecimalType dt = (DecimalType)flinkType.getLogicalType();
                        LogicalTypes.Decimal avroType = LogicalTypes.decimal(dt.getPrecision(), dt.getScale());
                        int fixedSize = minBytesForPrecision[dt.getPrecision()];
                        String name = namespace.equals("") ? recordName + ".fixed" : namespace + recordName + ".fixed";
                        schema = avroType.addToSchema(SchemaBuilder.fixed(name).size(fixedSize));
                        break block19;
                    }
                    default: {
                        throw new IncompatibleSchemaException(String.format("Unsupported type %s", flinkType.toString()), null);
                    }
                }
            }
            if (flinkType instanceof CollectionDataType) {
                if (type != LogicalTypeRoot.ARRAY) throw new IncompatibleSchemaException("Pulsar only support collection as array", null);
                CollectionDataType cdt = (CollectionDataType)flinkType;
                DataType elementType = cdt.getElementDataType();
                schema = (Schema)builder.array().items(SimpleSchemaTranslator.sqlType2AvroSchema(elementType, elementType.getLogicalType().isNullable(), recordName, namespace));
            } else if (flinkType instanceof KeyValueDataType) {
                KeyValueDataType kvType = (KeyValueDataType)flinkType;
                DataType keyType = kvType.getKeyDataType();
                DataType valueType = kvType.getValueDataType();
                if (!(keyType instanceof AtomicDataType) || keyType.getLogicalType().getTypeRoot() != LogicalTypeRoot.VARCHAR) {
                    throw new IncompatibleSchemaException("Pulsar only support string key map", null);
                }
                schema = (Schema)builder.map().values(SimpleSchemaTranslator.sqlType2AvroSchema(valueType, valueType.getLogicalType().isNullable(), recordName, namespace));
            } else {
                if (!(flinkType instanceof FieldsDataType)) throw new IncompatibleSchemaException(String.format("Unexpected type %s", flinkType.toString()), null);
                FieldsDataType fieldsDataType = (FieldsDataType)flinkType;
                String childNamespace = namespace.equals("") ? recordName : namespace + "." + recordName;
                SchemaBuilder.FieldAssembler fieldsAssembler = ((SchemaBuilder.RecordBuilder)builder.record(recordName).namespace(namespace)).fields();
                RowType rowType = (RowType)fieldsDataType.getLogicalType();
                List filedNames = rowType.getFieldNames();
                for (int i = 0; i < filedNames.size(); ++i) {
                    String fieldName = (String)filedNames.get(i);
                    LogicalType logicalType = rowType.getTypeAt(i);
                    DataType ftype = TypeConversions.fromLogicalToDataType((LogicalType)logicalType);
                    Schema fieldAvroSchema = SimpleSchemaTranslator.sqlType2AvroSchema(ftype, ftype.getLogicalType().isNullable(), fieldName, childNamespace);
                    fieldsAssembler.name(fieldName).type(fieldAvroSchema).noDefault();
                }
                schema = (Schema)fieldsAssembler.endRecord();
            }
        }
        if (!nullable) return schema;
        return Schema.createUnion(schema, NULL_SCHEMA);
    }

    public static SchemaInfo emptySchemaInfo() {
        return SchemaInfoImpl.builder().name("empty").type(SchemaType.NONE).schema(new byte[0]).build();
    }

    private static int computeMinBytesForPrecision(int precision) {
        int numBytes = 1;
        while (Math.pow(2.0, 8 * numBytes - 1) < Math.pow(10.0, precision)) {
            ++numBytes;
        }
        return numBytes;
    }

    @Override
    public TableSchema pulsarSchemaToTableSchema(SchemaInfo pulsarSchema) throws IncompatibleSchemaException {
        FieldsDataType fieldsDataType = this.pulsarSchemaToFieldsDataType(pulsarSchema);
        RowType rt = (RowType)fieldsDataType.getLogicalType();
        List fieldTypes = fieldsDataType.getChildren();
        return TableSchema.builder().fields(rt.getFieldNames().toArray(new String[0]), fieldTypes.toArray(new DataType[0])).build();
    }

    @Override
    public FieldsDataType pulsarSchemaToFieldsDataType(SchemaInfo schemaInfo) throws IncompatibleSchemaException {
        ArrayList<DataTypes.Field> mainSchema = new ArrayList<DataTypes.Field>();
        DataType dataType = this.schemaInfo2SqlType(schemaInfo);
        if (dataType instanceof FieldsDataType) {
            FieldsDataType fieldsDataType = (FieldsDataType)dataType;
            RowType rowType = (RowType)fieldsDataType.getLogicalType();
            List fieldNames = rowType.getFieldNames();
            for (int i = 0; i < fieldNames.size(); ++i) {
                LogicalType logicalType = rowType.getTypeAt(i);
                DataTypes.Field field = DataTypes.FIELD((String)((String)fieldNames.get(i)), (DataType)TypeConversions.fromLogicalToDataType((LogicalType)logicalType));
                mainSchema.add(field);
            }
        } else {
            mainSchema.add(DataTypes.FIELD((String)"value", (DataType)dataType));
        }
        if (this.useExtendField) {
            mainSchema.addAll(METADATA_FIELDS);
        }
        return (FieldsDataType)DataTypes.ROW((DataTypes.Field[])mainSchema.toArray(new DataTypes.Field[0]));
    }

    @Override
    public DataType schemaInfo2SqlType(SchemaInfo si) throws IncompatibleSchemaException {
        switch (si.getType()) {
            case NONE: 
            case BYTES: {
                return DataTypes.BYTES();
            }
            case BOOLEAN: {
                return DataTypes.BOOLEAN();
            }
            case LOCAL_DATE: {
                return DataTypes.DATE();
            }
            case LOCAL_TIME: {
                return DataTypes.TIME();
            }
            case STRING: {
                return DataTypes.STRING();
            }
            case LOCAL_DATE_TIME: {
                return DataTypes.TIMESTAMP((int)3);
            }
            case INT8: {
                return DataTypes.TINYINT();
            }
            case DOUBLE: {
                return DataTypes.DOUBLE();
            }
            case FLOAT: {
                return DataTypes.FLOAT();
            }
            case INT32: {
                return DataTypes.INT();
            }
            case INT64: {
                return DataTypes.BIGINT();
            }
            case INT16: {
                return DataTypes.SMALLINT();
            }
            case AVRO: 
            case JSON: {
                String avroSchemaString = new String(si.getSchema(), StandardCharsets.UTF_8);
                return AvroSchemaConverter.convertToDataType((String)avroSchemaString);
            }
            case PROTOBUF_NATIVE: {
                Descriptors.Descriptor descriptor = ((GenericProtobufNativeSchema)GenericProtobufNativeSchema.of(si)).getProtobufNativeSchema();
                return SimpleSchemaTranslator.proto2SqlType(descriptor);
            }
        }
        throw new UnsupportedOperationException(String.format("We do not support %s currently.", new Object[]{si.getType()}));
    }

    private static DataType proto2SqlType(Descriptors.Descriptor descriptor) throws IncompatibleSchemaException {
        ArrayList<DataTypes.Field> fields = new ArrayList<DataTypes.Field>();
        List protoFields = descriptor.getFields();
        for (Descriptors.FieldDescriptor fieldDescriptor : protoFields) {
            DataType fieldType = SimpleSchemaTranslator.proto2SqlType(fieldDescriptor);
            fields.add(DataTypes.FIELD((String)fieldDescriptor.getName(), (DataType)fieldType));
        }
        if (fields.isEmpty()) {
            throw new IllegalArgumentException("No FieldDescriptors found");
        }
        return DataTypes.ROW((DataTypes.Field[])fields.toArray(new DataTypes.Field[0]));
    }

    private static DataType proto2SqlType(Descriptors.FieldDescriptor field) throws IncompatibleSchemaException {
        DataType dataType;
        Descriptors.FieldDescriptor.JavaType type = field.getJavaType();
        switch (type) {
            case BOOLEAN: {
                dataType = DataTypes.BOOLEAN();
                break;
            }
            case BYTE_STRING: {
                dataType = DataTypes.BYTES();
                break;
            }
            case DOUBLE: {
                dataType = DataTypes.DOUBLE();
                break;
            }
            case ENUM: {
                dataType = DataTypes.STRING();
                break;
            }
            case FLOAT: {
                dataType = DataTypes.FLOAT();
                break;
            }
            case INT: {
                dataType = DataTypes.INT();
                break;
            }
            case LONG: {
                dataType = DataTypes.BIGINT();
                break;
            }
            case MESSAGE: {
                Descriptors.Descriptor msg = field.getMessageType();
                if (field.isMapField()) {
                    dataType = DataTypes.MAP((DataType)SimpleSchemaTranslator.proto2SqlType(msg.findFieldByName("key")), (DataType)SimpleSchemaTranslator.proto2SqlType(msg.findFieldByName("value")));
                    break;
                }
                dataType = SimpleSchemaTranslator.proto2SqlType(field.getMessageType());
                break;
            }
            case STRING: {
                dataType = DataTypes.STRING();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + type.toString() + " for FieldDescriptor: " + field.toString());
            }
        }
        if (field.isRepeated() && !field.isMapField()) {
            dataType = DataTypes.ARRAY((DataType)dataType);
        }
        return dataType;
    }

    public boolean isUseExtendField() {
        return this.useExtendField;
    }

    static {
        for (int i = 0; i < minBytesForPrecision.length; ++i) {
            SimpleSchemaTranslator.minBytesForPrecision[i] = SimpleSchemaTranslator.computeMinBytesForPrecision(i);
        }
        METADATA_FIELDS = ImmutableList.of(DataTypes.FIELD((String)"__key", (DataType)DataTypes.BYTES()), DataTypes.FIELD((String)"__topic", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"__messageId", (DataType)DataTypes.BYTES()), DataTypes.FIELD((String)"__publishTime", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"__eventTime", (DataType)DataTypes.TIMESTAMP((int)3)));
    }
}

