/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.pulsar.client.api.MessageId;

public class MessageIdSerializer
extends TypeSerializer<MessageId> {
    public static final MessageIdSerializer INSTANCE = new MessageIdSerializer();

    public boolean isImmutableType() {
        return true;
    }

    public TypeSerializer<MessageId> duplicate() {
        return this;
    }

    public MessageId createInstance() {
        return MessageId.earliest;
    }

    public MessageId copy(MessageId from) {
        try {
            return MessageId.fromByteArray(from.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException("MessageId copy should not throw an exception", e);
        }
    }

    public MessageId copy(MessageId from, MessageId reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(MessageId record, DataOutputView target) throws IOException {
        byte[] bytes = record.toByteArray();
        target.writeInt(bytes.length);
        target.write(bytes);
    }

    public MessageId deserialize(DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        return MessageId.fromByteArray(bytes);
    }

    public MessageId deserialize(MessageId reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && ((Object)((Object)this)).getClass() == obj.getClass();
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public TypeSerializerSnapshot<MessageId> snapshotConfiguration() {
        return new MessageIdSerializerSnapshot();
    }

    public static final class MessageIdSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<MessageId> {
        public MessageIdSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

