/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.serialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatUtils;
import org.apache.flink.formats.protobuf.serialize.PbCodegenArraySerializer;
import org.apache.flink.formats.protobuf.serialize.PbCodegenMapSerializer;
import org.apache.flink.formats.protobuf.serialize.PbCodegenRowSerializer;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializer;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSimpleSerializer;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;

public class PbCodegenSerializeFactory {
    public static PbCodegenSerializer getPbCodegenSer(Descriptors.FieldDescriptor fd, LogicalType type) throws PbCodegenException {
        if (type instanceof RowType) {
            return new PbCodegenRowSerializer(fd.getMessageType(), (RowType)type);
        }
        if (PbFormatUtils.isSimpleType(type)) {
            return new PbCodegenSimpleSerializer(fd, type);
        }
        if (type instanceof ArrayType) {
            return new PbCodegenArraySerializer(fd, ((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            return new PbCodegenMapSerializer(fd, (MapType)type);
        }
        throw new PbCodegenException("Cannot support flink data type: " + type);
    }

    public static PbCodegenSerializer getPbCodegenTopRowSer(Descriptors.Descriptor descriptor, RowType rowType) {
        return new PbCodegenRowSerializer(descriptor, rowType);
    }
}

