/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.serialize;

import com.google.protobuf.Descriptors;
import java.util.List;
import org.apache.flink.formats.protobuf.PbCodegenAppender;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbCodegenUtils;
import org.apache.flink.formats.protobuf.PbCodegenVarId;
import org.apache.flink.formats.protobuf.PbFormatUtils;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializeFactory;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

public class PbCodegenRowSerializer
implements PbCodegenSerializer {
    private List<Descriptors.FieldDescriptor> fds;
    private Descriptors.Descriptor descriptor;
    private RowType rowType;

    public PbCodegenRowSerializer(Descriptors.Descriptor descriptor, RowType rowType) {
        this.fds = descriptor.getFields();
        this.rowType = rowType;
        this.descriptor = descriptor;
    }

    @Override
    public String codegen(String returnVarName, String rowFieldGetStr) throws PbCodegenException {
        PbCodegenVarId varUid = PbCodegenVarId.getInstance();
        int uid = varUid.getAndIncrement();
        PbCodegenAppender appender = new PbCodegenAppender();
        String rowDataVar = "rowData" + uid;
        String pbMessageTypeStr = PbFormatUtils.getFullJavaName(this.descriptor);
        String messageBuilderVar = "messageBuilder" + uid;
        appender.appendLine("RowData " + rowDataVar + " = " + rowFieldGetStr);
        appender.appendLine(pbMessageTypeStr + ".Builder " + messageBuilderVar + " = " + pbMessageTypeStr + ".newBuilder()");
        int index = 0;
        for (String fieldName : this.rowType.getFieldNames()) {
            Descriptors.FieldDescriptor elementFd = this.descriptor.findFieldByName(fieldName);
            LogicalType subType = this.rowType.getTypeAt(this.rowType.getFieldIndex(fieldName));
            int subUid = varUid.getAndIncrement();
            String elementPbVar = "elementPbVar" + subUid;
            String elementPbTypeStr = elementFd.isMapField() ? PbCodegenUtils.getTypeStrFromProto(elementFd, false) : PbCodegenUtils.getTypeStrFromProto(elementFd, elementFd.isRepeated());
            String strongCamelFieldName = PbFormatUtils.getStrongCamelCaseJsonName(fieldName);
            appender.appendSegment("if(!" + rowDataVar + ".isNullAt(" + index + ")){");
            appender.appendLine(elementPbTypeStr + " " + elementPbVar);
            String subRowGetCode = PbCodegenUtils.getContainerDataFieldGetterCodePhrase(rowDataVar, index + "", subType);
            PbCodegenSerializer codegen = PbCodegenSerializeFactory.getPbCodegenSer(elementFd, subType);
            String code = codegen.codegen(elementPbVar, subRowGetCode);
            appender.appendSegment(code);
            if (subType.getTypeRoot() == LogicalTypeRoot.ARRAY) {
                appender.appendLine(messageBuilderVar + ".addAll" + strongCamelFieldName + "(" + elementPbVar + ")");
            } else if (subType.getTypeRoot() == LogicalTypeRoot.MAP) {
                appender.appendLine(messageBuilderVar + ".putAll" + strongCamelFieldName + "(" + elementPbVar + ")");
            } else {
                appender.appendLine(messageBuilderVar + ".set" + strongCamelFieldName + "(" + elementPbVar + ")");
            }
            appender.appendSegment("}");
            ++index;
        }
        appender.appendLine(returnVarName + " = " + messageBuilderVar + ".build()");
        return appender.code();
    }
}

