/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.validation.constraints.Pattern;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.projectnessie.api.params.AbstractParams;

public class RefLogParams
extends AbstractParams {
    @Nullable
    @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes")
    @Parameter(description="Hash of the reflog (inclusive) to start from (in chronological sense), the 'far' end of the reflog, returned 'late' in the result.")
    @QueryParam(value="startHash")
    private @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String startHash;
    @Nullable
    @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes")
    @Parameter(description="Hash of the reflog (inclusive) to end at (in chronological sense), the 'near' end of the reflog, returned 'early' in the result.")
    @QueryParam(value="endHash")
    private @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String endHash;

    public RefLogParams() {
    }

    private RefLogParams(String startHash, String endHash, Integer maxRecords, String pageToken) {
        super(maxRecords, pageToken);
        this.startHash = startHash;
        this.endHash = endHash;
    }

    private RefLogParams(Builder builder) {
        this(builder.startHash, builder.endHash, builder.maxRecords, builder.pageToken);
    }

    @Nullable
    public String startHash() {
        return this.startHash;
    }

    @Nullable
    public String endHash() {
        return this.endHash;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RefLogParams empty() {
        return new Builder().build();
    }

    public String toString() {
        return new StringJoiner(", ", RefLogParams.class.getSimpleName() + "[", "]").add("startHash='" + this.startHash + "'").add("endHash='" + this.endHash + "'").add("maxRecords=" + this.maxRecords()).add("pageToken='" + this.pageToken() + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefLogParams that = (RefLogParams)o;
        return Objects.equals(this.startHash, that.startHash) && Objects.equals(this.endHash, that.endHash) && Objects.equals(this.maxRecords(), that.maxRecords()) && Objects.equals(this.pageToken(), that.pageToken());
    }

    public int hashCode() {
        return Objects.hash(this.startHash, this.endHash, this.maxRecords(), this.pageToken());
    }

    public static class Builder
    extends AbstractParams.Builder<Builder> {
        private String startHash;
        private String endHash;

        private Builder() {
        }

        public Builder startHash(String startHash) {
            this.startHash = startHash;
            return this;
        }

        public Builder endHash(String endHash) {
            this.endHash = endHash;
            return this;
        }

        public Builder from(RefLogParams params) {
            return (Builder)((Builder)this.startHash(params.startHash).endHash(params.endHash).maxRecords(params.maxRecords())).pageToken(params.pageToken());
        }

        public RefLogParams build() {
            return new RefLogParams(this);
        }
    }
}

