/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.Text;
import org.apache.orc.impl.HadoopShims;
import org.apache.orc.impl.ZeroCopyShims;

public class HadoopShims_2_2
implements HadoopShims {
    final boolean zeroCopy;
    final boolean fastRead;

    HadoopShims_2_2() {
        boolean zcr = false;
        try {
            Class.forName("org.apache.hadoop.fs.CacheFlag", false, HadoopShims_2_2.class.getClassLoader());
            zcr = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.zeroCopy = zcr;
        boolean fastRead = false;
        if (zcr) {
            for (Method m3 : Text.class.getMethods()) {
                if (!"readWithKnownLength".equals(m3.getName())) continue;
                fastRead = true;
            }
        }
        this.fastRead = fastRead;
    }

    @Override
    public HadoopShims.DirectDecompressor getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        return null;
    }

    @Override
    public HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        if (this.zeroCopy) {
            return ZeroCopyShims.getZeroCopyReader(in, pool);
        }
        return null;
    }

    @Override
    public HadoopShims.TextReaderShim getTextReaderShim(InputStream in) throws IOException {
        return new BasicTextReaderShim(in);
    }

    private static final class BasicTextReaderShim
    implements HadoopShims.TextReaderShim {
        private final InputStream in;

        public BasicTextReaderShim(InputStream in) {
            this.in = in;
        }

        @Override
        public void read(Text txt, int len) throws IOException {
            int offset = 0;
            byte[] bytes = new byte[len];
            while (len > 0) {
                int written = this.in.read(bytes, offset, len);
                if (written < 0) {
                    throw new EOFException("Can't finish read from " + this.in + " read " + offset + " bytes out of " + bytes.length);
                }
                len -= written;
                offset += written;
            }
            txt.set(bytes);
        }
    }
}

