/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.iceberg.sink;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.iceberg.flink.sink.TaskWriterFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.inlong.sort.base.metric.SinkMetricData;
import org.apache.inlong.sort.base.metric.ThreadSafeCounter;

class IcebergStreamWriter<T>
extends AbstractStreamOperator<WriteResult>
implements OneInputStreamOperator<T, WriteResult>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final String fullTableName;
    private final TaskWriterFactory<T> taskWriterFactory;
    private final String inLongMetric;
    private final String auditHostAndPorts;
    private transient TaskWriter<T> writer;
    private transient int subTaskId;
    private transient int attemptId;
    @Nullable
    private transient SinkMetricData metricData;

    IcebergStreamWriter(String fullTableName, TaskWriterFactory<T> taskWriterFactory, String inLongMetric, String auditHostAndPorts) {
        this.fullTableName = fullTableName;
        this.taskWriterFactory = taskWriterFactory;
        this.inLongMetric = inLongMetric;
        this.auditHostAndPorts = auditHostAndPorts;
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    public void open() {
        this.subTaskId = this.getRuntimeContext().getIndexOfThisSubtask();
        this.attemptId = this.getRuntimeContext().getAttemptNumber();
        this.taskWriterFactory.initialize(this.subTaskId, this.attemptId);
        this.writer = this.taskWriterFactory.create();
        if (this.inLongMetric != null) {
            String[] inLongMetricArray = this.inLongMetric.split("&");
            String inLongGroupId = inLongMetricArray[0];
            String inLongStreamId = inLongMetricArray[1];
            String nodeId = inLongMetricArray[2];
            this.metricData = new SinkMetricData(inLongGroupId, inLongStreamId, nodeId, this.getRuntimeContext().getMetricGroup(), this.auditHostAndPorts);
            this.metricData.registerMetricsForDirtyBytes(new ThreadSafeCounter());
            this.metricData.registerMetricsForDirtyRecords(new ThreadSafeCounter());
            this.metricData.registerMetricsForNumBytesOut(new ThreadSafeCounter());
            this.metricData.registerMetricsForNumRecordsOut(new ThreadSafeCounter());
            this.metricData.registerMetricsForNumBytesOutPerSecond();
            this.metricData.registerMetricsForNumRecordsOutPerSecond();
        }
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        this.emit(this.writer.complete());
        this.writer = this.taskWriterFactory.create();
    }

    public void processElement(StreamRecord<T> element) throws Exception {
        this.writer.write(element.getValue());
        if (this.metricData != null) {
            this.metricData.invokeWithEstimate(element.getValue());
        }
    }

    public void dispose() throws Exception {
        super.dispose();
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public void endInput() throws IOException {
        this.emit(this.writer.complete());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table_name", this.fullTableName).add("subtask_id", this.subTaskId).add("attempt_id", this.attemptId).toString();
    }

    private void emit(WriteResult result) {
        this.output.collect((Object)new StreamRecord((Object)result));
    }
}

