/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.iceberg;

import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsOverwrite;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.iceberg.FlinkConfigOptions;
import org.apache.inlong.sort.iceberg.sink.FlinkSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergTableSink
implements DynamicTableSink,
SupportsPartitioning,
SupportsOverwrite {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergTableSink.class);
    private final TableLoader tableLoader;
    private final TableSchema tableSchema;
    private final CatalogTable catalogTable;
    private boolean overwrite = false;

    private IcebergTableSink(IcebergTableSink toCopy) {
        this.tableLoader = toCopy.tableLoader;
        this.tableSchema = toCopy.tableSchema;
        this.overwrite = toCopy.overwrite;
        this.catalogTable = toCopy.catalogTable;
    }

    public IcebergTableSink(TableLoader tableLoader, TableSchema tableSchema, CatalogTable catalogTable) {
        this.tableLoader = tableLoader;
        this.tableSchema = tableSchema;
        this.catalogTable = catalogTable;
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        Preconditions.checkState((!this.overwrite || context.isBounded() ? 1 : 0) != 0, (Object)"Unbounded data stream doesn't support overwrite operation.");
        List equalityColumns = this.tableSchema.getPrimaryKey().map(UniqueConstraint::getColumns).orElseGet(ImmutableList::of);
        return dataStream -> FlinkSink.forRowData((DataStream<RowData>)dataStream).tableLoader(this.tableLoader).tableSchema(this.tableSchema).equalityFieldColumns(equalityColumns).overwrite(this.overwrite).metric((String)this.catalogTable.getOptions().getOrDefault(Constants.INLONG_METRIC.key(), Constants.INLONG_METRIC.defaultValue()), (String)this.catalogTable.getOptions().getOrDefault(Constants.INLONG_AUDIT.key(), Constants.INLONG_AUDIT.defaultValue())).append();
    }

    public void applyStaticPartition(Map<String, String> partition) {
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        if (((Boolean)Configuration.fromMap((Map)this.catalogTable.getOptions()).get(FlinkConfigOptions.ICEBERG_IGNORE_ALL_CHANGELOG)).booleanValue()) {
            LOG.warn("Iceberg sink receive all changelog record. Regard any other record as insert-only record.");
            return ChangelogMode.all();
        }
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        for (RowKind kind : requestedMode.getContainedKinds()) {
            builder.addContainedKind(kind);
        }
        return builder.build();
    }

    public DynamicTableSink copy() {
        return new IcebergTableSink(this);
    }

    public String asSummaryString() {
        return "Iceberg table sink";
    }

    public void applyOverwrite(boolean newOverwrite) {
        this.overwrite = newOverwrite;
    }
}

