/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.metric;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.lang3.ClassUtils;
import org.apache.inlong.common.metric.MetricItem;
import org.apache.inlong.common.metric.MetricItemMBean;
import org.apache.inlong.common.metric.MetricItemSetMBean;
import org.apache.inlong.common.metric.MetricItemValue;
import org.apache.inlong.common.metric.MetricListener;
import org.apache.inlong.common.metric.MetricValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricListenerRunnable
implements Runnable {
    public static final Logger LOG = LoggerFactory.getLogger(MetricListenerRunnable.class);
    private String domain;
    private List<MetricListener> listenerList;

    public MetricListenerRunnable(String domain, List<MetricListener> listenerList) {
        this.domain = domain;
        this.listenerList = listenerList;
    }

    @Override
    public void run() {
        LOG.debug("begin to snapshot metric:{}", (Object)this.domain);
        try {
            List<MetricItemValue> itemValues = this.getItemValues();
            LOG.debug("snapshot metric:{},size:{}", (Object)this.domain, (Object)itemValues.size());
            this.listenerList.forEach(item -> item.snapshot(this.domain, itemValues));
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
        }
        LOG.debug("end to snapshot metric:{}", (Object)this.domain);
    }

    public List<MetricItemValue> getItemValues() throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, MalformedObjectNameException, ClassNotFoundException {
        StringBuilder beanName = new StringBuilder();
        beanName.append("org.apache.inlong").append(':').append("type=").append(this.domain).append(',').append("*");
        ObjectName objName = new ObjectName(beanName.toString());
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectInstance> mbeans = mbs.queryMBeans(objName, null);
        LOG.debug("getItemValues for domain:{},queryMBeans:{}", (Object)this.domain, mbeans);
        ArrayList<MetricItemValue> itemValues = new ArrayList<MetricItemValue>();
        for (ObjectInstance mbean : mbeans) {
            ObjectName metricObjectName;
            String className = mbean.getClassName();
            Class<?> clazz = ClassUtils.getClass(className);
            if (ClassUtils.isAssignable(clazz, MetricItemMBean.class)) {
                metricObjectName = mbean.getObjectName();
                String dimensionsKey = (String)mbs.getAttribute(metricObjectName, "DimensionsKey");
                Map dimensions = (Map)mbs.getAttribute(metricObjectName, "Dimensions");
                Map metrics = (Map)mbs.invoke(metricObjectName, "snapshot", null, null);
                MetricItemValue itemValue = new MetricItemValue(dimensionsKey, dimensions, metrics);
                LOG.debug("MetricItemMBean get itemValue:{}", (Object)itemValue);
                itemValues.add(itemValue);
                continue;
            }
            if (!ClassUtils.isAssignable(clazz, MetricItemSetMBean.class)) continue;
            metricObjectName = mbean.getObjectName();
            List items = (List)mbs.invoke(metricObjectName, "snapshot", null, null);
            for (Object itemT : items) {
                if (!(itemT instanceof MetricItem)) continue;
                MetricItem item = (MetricItem)itemT;
                String dimensionsKey = item.getDimensionsKey();
                Map<String, String> dimensions = item.getDimensions();
                Map<String, MetricValue> metrics = item.snapshot();
                MetricItemValue itemValue = new MetricItemValue(dimensionsKey, dimensions, metrics);
                LOG.debug("MetricItemSetMBean get itemValue:{}", (Object)itemValue);
                itemValues.add(itemValue);
            }
        }
        return itemValues;
    }
}

