/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.iceberg.shaded.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.ValuesReader;
import org.apache.iceberg.shaded.org.apache.parquet.io.ParquetDecodingException;

public class ValuesAsBytesReader
extends ValuesReader {
    private ByteBufferInputStream valuesInputStream = null;
    private int bitOffset;
    private byte currentByte = 0;

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream in) {
        this.valuesInputStream = in;
    }

    @Override
    public void skip() {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer getBuffer(int length) {
        try {
            return this.valuesInputStream.slice(length).order(ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read " + length + " bytes", e);
        }
    }

    @Override
    public final int readInteger() {
        return this.getBuffer(4).getInt();
    }

    @Override
    public final long readLong() {
        return this.getBuffer(8).getLong();
    }

    @Override
    public final float readFloat() {
        return this.getBuffer(4).getFloat();
    }

    @Override
    public final double readDouble() {
        return this.getBuffer(8).getDouble();
    }

    @Override
    public final boolean readBoolean() {
        if (this.bitOffset == 0) {
            this.currentByte = this.getByte();
        }
        boolean value = (this.currentByte & 1 << this.bitOffset) != 0;
        ++this.bitOffset;
        if (this.bitOffset == 8) {
            this.bitOffset = 0;
        }
        return value;
    }

    public final int readBooleanAsInt() {
        if (this.bitOffset == 0) {
            this.currentByte = this.getByte();
        }
        int value = (this.currentByte & 1 << this.bitOffset) >> this.bitOffset;
        ++this.bitOffset;
        if (this.bitOffset == 8) {
            this.bitOffset = 0;
        }
        return value;
    }

    private byte getByte() {
        try {
            return (byte)this.valuesInputStream.read();
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read a byte", e);
        }
    }
}

