/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.util.Map;
import java.util.function.Predicate;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.nessie.NessieUtil;
import org.apache.iceberg.nessie.UpdateableReference;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieTableOperations
extends BaseMetastoreTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(NessieTableOperations.class);
    private final NessieApiV1 api;
    private final ContentKey key;
    private final UpdateableReference reference;
    private IcebergTable table;
    private final FileIO fileIO;
    private final Map<String, String> catalogOptions;

    NessieTableOperations(ContentKey key, UpdateableReference reference, NessieApiV1 api, FileIO fileIO, Map<String, String> catalogOptions) {
        this.key = key;
        this.reference = reference;
        this.api = api;
        this.fileIO = fileIO;
        this.catalogOptions = catalogOptions;
    }

    @Override
    protected String tableName() {
        return this.key.toString();
    }

    @Override
    protected void refreshFromMetadataLocation(String newLocation, Predicate<Exception> shouldRetry, int numRetries) {
        super.refreshFromMetadataLocation(newLocation, shouldRetry, numRetries, this::loadTableMetadata);
    }

    private TableMetadata loadTableMetadata(String metadataLocation) {
        return TableMetadata.buildFrom(TableMetadataParser.read(this.io(), metadataLocation)).setCurrentSnapshot(this.table.getSnapshotId()).setCurrentSchema(this.table.getSchemaId()).setDefaultSortOrder(this.table.getSortOrderId()).setDefaultPartitionSpec(this.table.getSpecId()).discardChanges().build();
    }

    @Override
    protected void doRefresh() {
        String metadataLocation;
        block7: {
            try {
                this.reference.refresh(this.api);
            }
            catch (NessieNotFoundException e) {
                throw new RuntimeException("Failed to refresh as ref is no longer valid.", e);
            }
            metadataLocation = null;
            try {
                Content content = ((GetContentBuilder)this.api.getContent().key(this.key).reference(this.reference.getReference())).get().get(this.key);
                LOG.debug("Content '{}' at '{}': {}", new Object[]{this.key, this.reference.getReference(), content});
                if (content == null) {
                    if (this.currentMetadataLocation() != null) {
                        throw new NoSuchTableException("No such table %s in %s", this.key, this.reference.getReference());
                    }
                } else {
                    this.table = content.unwrap(IcebergTable.class).orElseThrow(() -> new IllegalStateException("Cannot refresh iceberg table: " + String.format("Nessie points to a non-Iceberg object for path: %s.", this.key)));
                    metadataLocation = this.table.getMetadataLocation();
                }
            }
            catch (NessieNotFoundException ex) {
                if (this.currentMetadataLocation() == null) break block7;
                throw new NoSuchTableException(ex, "No such table %s", this.key);
            }
        }
        this.refreshFromMetadataLocation(metadataLocation, 2);
    }

    @Override
    protected void doCommit(TableMetadata base, TableMetadata metadata) {
        this.reference.checkMutable();
        String newMetadataLocation = this.writeNewMetadata(metadata, this.currentVersion() + 1);
        boolean delete = true;
        try {
            Snapshot snapshot;
            ImmutableIcebergTable.Builder newTableBuilder = ImmutableIcebergTable.builder();
            if (this.table != null) {
                newTableBuilder.id(this.table.getId());
            }
            long snapshotId = (snapshot = metadata.currentSnapshot()) != null ? snapshot.snapshotId() : -1L;
            ImmutableIcebergTable newTable = newTableBuilder.snapshotId(snapshotId).schemaId(metadata.currentSchemaId()).specId(metadata.defaultSpecId()).sortOrderId(metadata.defaultSortOrderId()).metadataLocation(newMetadataLocation).build();
            LOG.debug("Committing '{}' against '{}': {}", new Object[]{this.key, this.reference.getReference(), newTable});
            ImmutableCommitMeta.Builder builder = ImmutableCommitMeta.builder();
            builder.message(this.buildCommitMsg(base, metadata));
            if (this.isSnapshotOperation(base, metadata)) {
                builder.putProperties("iceberg.operation", snapshot.operation());
            }
            Branch branch = ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().operation(Operation.Put.of(this.key, newTable, this.table)).commitMeta(NessieUtil.catalogOptions(builder, this.catalogOptions).build()).branch(this.reference.getAsBranch())).commit();
            this.reference.updateReference(branch);
            delete = false;
        }
        catch (NessieConflictException ex) {
            throw new CommitFailedException(ex, "Commit failed: Reference hash is out of date. Update the reference %s and try again", this.reference.getName());
        }
        catch (HttpClientException ex) {
            delete = false;
            throw new CommitStateUnknownException(ex);
        }
        catch (NessieNotFoundException ex) {
            throw new RuntimeException(String.format("Commit failed: Reference %s no longer exist", this.reference.getName()), ex);
        }
        finally {
            if (delete) {
                this.io().deleteFile(newMetadataLocation);
            }
        }
    }

    private boolean isSnapshotOperation(TableMetadata base, TableMetadata metadata) {
        Snapshot snapshot = metadata.currentSnapshot();
        return snapshot != null && (base == null || base.currentSnapshot() == null || snapshot.snapshotId() != base.currentSnapshot().snapshotId());
    }

    private String buildCommitMsg(TableMetadata base, TableMetadata metadata) {
        if (this.isSnapshotOperation(base, metadata)) {
            return String.format("Iceberg %s against %s", metadata.currentSnapshot().operation(), this.tableName());
        }
        if (base != null && metadata.currentSchemaId() != base.currentSchemaId()) {
            return String.format("Iceberg schema change against %s", this.tableName());
        }
        return String.format("Iceberg commit against %s", this.tableName());
    }

    @Override
    public FileIO io() {
        return this.fileIO;
    }
}

