/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.ClusteredWriter;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.RollingDataWriter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class ClusteredDataWriter<T>
extends ClusteredWriter<T, DataWriteResult> {
    private final FileWriterFactory<T> writerFactory;
    private final OutputFileFactory fileFactory;
    private final FileIO io;
    private final FileFormat fileFormat;
    private final long targetFileSizeInBytes;
    private final List<DataFile> dataFiles;

    public ClusteredDataWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, FileFormat fileFormat, long targetFileSizeInBytes) {
        this.writerFactory = writerFactory;
        this.fileFactory = fileFactory;
        this.io = io;
        this.fileFormat = fileFormat;
        this.targetFileSizeInBytes = targetFileSizeInBytes;
        this.dataFiles = Lists.newArrayList();
    }

    @Override
    protected FileWriter<T, DataWriteResult> newWriter(PartitionSpec spec, StructLike partition) {
        if (this.fileFormat == FileFormat.ORC) {
            EncryptedOutputFile outputFile = this.newOutputFile(this.fileFactory, spec, partition);
            return this.writerFactory.newDataWriter(outputFile, spec, partition);
        }
        return new RollingDataWriter<T>(this.writerFactory, this.fileFactory, this.io, this.targetFileSizeInBytes, spec, partition);
    }

    @Override
    protected void addResult(DataWriteResult result) {
        this.dataFiles.addAll(result.dataFiles());
    }

    @Override
    protected DataWriteResult aggregatedResult() {
        return new DataWriteResult(this.dataFiles);
    }
}

