/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.encryption.InputFilesDecryptor;
import org.apache.iceberg.flink.source.FileScanTaskReader;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;

@Internal
public class DataIterator<T>
implements CloseableIterator<T> {
    private final FileScanTaskReader<T> fileScanTaskReader;
    private final InputFilesDecryptor inputFilesDecryptor;
    private Iterator<FileScanTask> tasks;
    private CloseableIterator<T> currentIterator;

    public DataIterator(FileScanTaskReader<T> fileScanTaskReader, CombinedScanTask task, FileIO io, EncryptionManager encryption) {
        this.fileScanTaskReader = fileScanTaskReader;
        this.inputFilesDecryptor = new InputFilesDecryptor(task, io, encryption);
        this.tasks = task.files().iterator();
        this.currentIterator = CloseableIterator.empty();
    }

    @Override
    public boolean hasNext() {
        this.updateCurrentIterator();
        return this.currentIterator.hasNext();
    }

    @Override
    public T next() {
        this.updateCurrentIterator();
        return (T)this.currentIterator.next();
    }

    private void updateCurrentIterator() {
        try {
            while (!this.currentIterator.hasNext() && this.tasks.hasNext()) {
                this.currentIterator.close();
                this.currentIterator = this.openTaskIterator(this.tasks.next());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private CloseableIterator<T> openTaskIterator(FileScanTask scanTask) {
        return this.fileScanTaskReader.open(scanTask, this.inputFilesDecryptor);
    }

    @Override
    public void close() throws IOException {
        this.currentIterator.close();
        this.tasks = null;
    }
}

