/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.BaseFileWriterFactory;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.data.FlinkAvroWriter;
import org.apache.iceberg.flink.data.FlinkOrcWriter;
import org.apache.iceberg.flink.data.FlinkParquetWriters;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class FlinkFileWriterFactory
extends BaseFileWriterFactory<RowData>
implements Serializable {
    private RowType dataFlinkType;
    private RowType equalityDeleteFlinkType;
    private RowType positionDeleteFlinkType;

    FlinkFileWriterFactory(Table table, FileFormat dataFileFormat, Schema dataSchema, RowType dataFlinkType, SortOrder dataSortOrder, FileFormat deleteFileFormat, int[] equalityFieldIds, Schema equalityDeleteRowSchema, RowType equalityDeleteFlinkType, SortOrder equalityDeleteSortOrder, Schema positionDeleteRowSchema, RowType positionDeleteFlinkType) {
        super(table, dataFileFormat, dataSchema, dataSortOrder, deleteFileFormat, equalityFieldIds, equalityDeleteRowSchema, equalityDeleteSortOrder, positionDeleteRowSchema);
        this.dataFlinkType = dataFlinkType;
        this.equalityDeleteFlinkType = equalityDeleteFlinkType;
        this.positionDeleteFlinkType = positionDeleteFlinkType;
    }

    static Builder builderFor(Table table) {
        return new Builder(table);
    }

    @Override
    protected void configureDataWrite(Avro.DataWriteBuilder builder) {
        builder.createWriterFunc(ignore -> new FlinkAvroWriter(this.dataFlinkType()));
    }

    @Override
    protected void configureEqualityDelete(Avro.DeleteWriteBuilder builder) {
        builder.createWriterFunc(ignored -> new FlinkAvroWriter(this.equalityDeleteFlinkType()));
    }

    @Override
    protected void configurePositionDelete(Avro.DeleteWriteBuilder builder) {
        int rowFieldIndex = this.positionDeleteFlinkType().getFieldIndex("row");
        if (rowFieldIndex >= 0) {
            RowType positionDeleteRowFlinkType = (RowType)this.positionDeleteFlinkType().getTypeAt(rowFieldIndex);
            builder.createWriterFunc(ignored -> new FlinkAvroWriter(positionDeleteRowFlinkType));
        }
    }

    @Override
    protected void configureDataWrite(Parquet.DataWriteBuilder builder) {
        builder.createWriterFunc(msgType -> FlinkParquetWriters.buildWriter((LogicalType)this.dataFlinkType(), msgType));
    }

    @Override
    protected void configureEqualityDelete(Parquet.DeleteWriteBuilder builder) {
        builder.createWriterFunc(msgType -> FlinkParquetWriters.buildWriter((LogicalType)this.equalityDeleteFlinkType(), msgType));
    }

    @Override
    protected void configurePositionDelete(Parquet.DeleteWriteBuilder builder) {
        builder.createWriterFunc(msgType -> FlinkParquetWriters.buildWriter((LogicalType)this.positionDeleteFlinkType(), msgType));
        builder.transformPaths(path -> StringData.fromString((String)path.toString()));
    }

    @Override
    protected void configureDataWrite(ORC.DataWriteBuilder builder) {
        builder.createWriterFunc((iSchema, typDesc) -> FlinkOrcWriter.buildWriter(this.dataFlinkType(), iSchema));
    }

    @Override
    protected void configureEqualityDelete(ORC.DeleteWriteBuilder builder) {
        builder.createWriterFunc((iSchema, typDesc) -> FlinkOrcWriter.buildWriter(this.equalityDeleteFlinkType(), iSchema));
    }

    @Override
    protected void configurePositionDelete(ORC.DeleteWriteBuilder builder) {
        builder.createWriterFunc((iSchema, typDesc) -> FlinkOrcWriter.buildWriter(this.positionDeleteFlinkType(), iSchema));
        builder.transformPaths(path -> StringData.fromString((String)path.toString()));
    }

    private RowType dataFlinkType() {
        if (this.dataFlinkType == null) {
            Preconditions.checkNotNull(this.dataSchema(), "Data schema must not be null");
            this.dataFlinkType = FlinkSchemaUtil.convert(this.dataSchema());
        }
        return this.dataFlinkType;
    }

    private RowType equalityDeleteFlinkType() {
        if (this.equalityDeleteFlinkType == null) {
            Preconditions.checkNotNull(this.equalityDeleteRowSchema(), "Equality delete schema must not be null");
            this.equalityDeleteFlinkType = FlinkSchemaUtil.convert(this.equalityDeleteRowSchema());
        }
        return this.equalityDeleteFlinkType;
    }

    private RowType positionDeleteFlinkType() {
        if (this.positionDeleteFlinkType == null) {
            Schema positionDeleteSchema = DeleteSchemaUtil.posDeleteSchema(this.positionDeleteRowSchema());
            this.positionDeleteFlinkType = FlinkSchemaUtil.convert(positionDeleteSchema);
        }
        return this.positionDeleteFlinkType;
    }

    static class Builder {
        private final Table table;
        private FileFormat dataFileFormat;
        private Schema dataSchema;
        private RowType dataFlinkType;
        private SortOrder dataSortOrder;
        private FileFormat deleteFileFormat;
        private int[] equalityFieldIds;
        private Schema equalityDeleteRowSchema;
        private RowType equalityDeleteFlinkType;
        private SortOrder equalityDeleteSortOrder;
        private Schema positionDeleteRowSchema;
        private RowType positionDeleteFlinkType;

        Builder(Table table) {
            this.table = table;
            Map<String, String> properties = table.properties();
            String dataFileFormatName = properties.getOrDefault("write.format.default", "parquet");
            this.dataFileFormat = FileFormat.valueOf(dataFileFormatName.toUpperCase(Locale.ENGLISH));
            String deleteFileFormatName = properties.getOrDefault("write.delete.format.default", dataFileFormatName);
            this.deleteFileFormat = FileFormat.valueOf(deleteFileFormatName.toUpperCase(Locale.ENGLISH));
        }

        Builder dataFileFormat(FileFormat newDataFileFormat) {
            this.dataFileFormat = newDataFileFormat;
            return this;
        }

        Builder dataSchema(Schema newDataSchema) {
            this.dataSchema = newDataSchema;
            return this;
        }

        Builder dataFlinkType(RowType newDataFlinkType) {
            this.dataFlinkType = newDataFlinkType;
            return this;
        }

        Builder dataSortOrder(SortOrder newDataSortOrder) {
            this.dataSortOrder = newDataSortOrder;
            return this;
        }

        Builder deleteFileFormat(FileFormat newDeleteFileFormat) {
            this.deleteFileFormat = newDeleteFileFormat;
            return this;
        }

        Builder equalityFieldIds(int[] newEqualityFieldIds) {
            this.equalityFieldIds = newEqualityFieldIds;
            return this;
        }

        Builder equalityDeleteRowSchema(Schema newEqualityDeleteRowSchema) {
            this.equalityDeleteRowSchema = newEqualityDeleteRowSchema;
            return this;
        }

        Builder equalityDeleteFlinkType(RowType newEqualityDeleteFlinkType) {
            this.equalityDeleteFlinkType = newEqualityDeleteFlinkType;
            return this;
        }

        Builder equalityDeleteSortOrder(SortOrder newEqualityDeleteSortOrder) {
            this.equalityDeleteSortOrder = newEqualityDeleteSortOrder;
            return this;
        }

        Builder positionDeleteRowSchema(Schema newPositionDeleteRowSchema) {
            this.positionDeleteRowSchema = newPositionDeleteRowSchema;
            return this;
        }

        Builder positionDeleteFlinkType(RowType newPositionDeleteFlinkType) {
            this.positionDeleteFlinkType = newPositionDeleteFlinkType;
            return this;
        }

        FlinkFileWriterFactory build() {
            boolean noEqualityDeleteConf = this.equalityFieldIds == null && this.equalityDeleteRowSchema == null;
            boolean fullEqualityDeleteConf = this.equalityFieldIds != null && this.equalityDeleteRowSchema != null;
            Preconditions.checkArgument(noEqualityDeleteConf || fullEqualityDeleteConf, "Equality field IDs and equality delete row schema must be set together");
            return new FlinkFileWriterFactory(this.table, this.dataFileFormat, this.dataSchema, this.dataFlinkType, this.dataSortOrder, this.deleteFileFormat, this.equalityFieldIds, this.equalityDeleteRowSchema, this.equalityDeleteFlinkType, this.equalityDeleteSortOrder, this.positionDeleteRowSchema, this.positionDeleteFlinkType);
        }
    }
}

