/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public interface CatalogLoader
extends Serializable {
    public Catalog loadCatalog();

    public static CatalogLoader hadoop(String name, Configuration hadoopConf, Map<String, String> properties) {
        return new HadoopCatalogLoader(name, hadoopConf, properties);
    }

    public static CatalogLoader hive(String name, Configuration hadoopConf, Map<String, String> properties) {
        return new HiveCatalogLoader(name, hadoopConf, properties);
    }

    public static CatalogLoader custom(String name, Map<String, String> properties, Configuration hadoopConf, String impl) {
        return new CustomCatalogLoader(name, properties, hadoopConf, impl);
    }

    public static class CustomCatalogLoader
    implements CatalogLoader {
        private final SerializableConfiguration hadoopConf;
        private final Map<String, String> properties;
        private final String name;
        private final String impl;

        private CustomCatalogLoader(String name, Map<String, String> properties, Configuration conf, String impl) {
            this.hadoopConf = new SerializableConfiguration(conf);
            this.properties = Maps.newHashMap(properties);
            this.name = name;
            this.impl = Preconditions.checkNotNull(impl, "Cannot initialize custom Catalog, impl class name is null");
        }

        @Override
        public Catalog loadCatalog() {
            return CatalogUtil.loadCatalog(this.impl, this.name, this.properties, this.hadoopConf.get());
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", this.name).add("impl", this.impl).toString();
        }
    }

    public static class HiveCatalogLoader
    implements CatalogLoader {
        private final String catalogName;
        private final SerializableConfiguration hadoopConf;
        private final String uri;
        private final String warehouse;
        private final int clientPoolSize;
        private final Map<String, String> properties;

        private HiveCatalogLoader(String catalogName, Configuration conf, Map<String, String> properties) {
            this.catalogName = catalogName;
            this.hadoopConf = new SerializableConfiguration(conf);
            this.uri = properties.get("uri");
            this.warehouse = properties.get("warehouse");
            this.clientPoolSize = properties.containsKey("clients") ? Integer.parseInt(properties.get("clients")) : 2;
            this.properties = Maps.newHashMap(properties);
        }

        @Override
        public Catalog loadCatalog() {
            return CatalogUtil.loadCatalog(HiveCatalog.class.getName(), this.catalogName, this.properties, this.hadoopConf.get());
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("catalogName", this.catalogName).add("uri", this.uri).add("warehouse", this.warehouse).add("clientPoolSize", this.clientPoolSize).toString();
        }
    }

    public static class HadoopCatalogLoader
    implements CatalogLoader {
        private final String catalogName;
        private final SerializableConfiguration hadoopConf;
        private final String warehouseLocation;
        private final Map<String, String> properties;

        private HadoopCatalogLoader(String catalogName, Configuration conf, Map<String, String> properties) {
            this.catalogName = catalogName;
            this.hadoopConf = new SerializableConfiguration(conf);
            this.warehouseLocation = properties.get("warehouse");
            this.properties = Maps.newHashMap(properties);
        }

        @Override
        public Catalog loadCatalog() {
            return CatalogUtil.loadCatalog(HadoopCatalog.class.getName(), this.catalogName, this.properties, this.hadoopConf.get());
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("catalogName", this.catalogName).add("warehouseLocation", this.warehouseLocation).toString();
        }
    }
}

