/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.function.Function;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;

public class InternalRecordWrapper
implements StructLike {
    private final Function<Object, Object>[] transforms;
    private StructLike wrapped = null;

    public InternalRecordWrapper(Types.StructType struct) {
        this.transforms = (Function[])struct.fields().stream().map(field -> InternalRecordWrapper.converter(field.type())).toArray(length -> (Function[])Array.newInstance(Function.class, length));
    }

    private static Function<Object, Object> converter(Type type) {
        switch (type.typeId()) {
            case DATE: {
                return date -> DateTimeUtil.daysFromDate((LocalDate)date);
            }
            case TIME: {
                return time -> DateTimeUtil.microsFromTime((LocalTime)time);
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    return timestamp -> DateTimeUtil.microsFromTimestamptz((OffsetDateTime)timestamp);
                }
                return timestamp -> DateTimeUtil.microsFromTimestamp((LocalDateTime)timestamp);
            }
            case FIXED: {
                return bytes -> ByteBuffer.wrap((byte[])bytes);
            }
            case STRUCT: {
                InternalRecordWrapper wrapper = new InternalRecordWrapper(type.asStructType());
                return struct -> wrapper.wrap((StructLike)struct);
            }
        }
        return null;
    }

    public StructLike get() {
        return this.wrapped;
    }

    public InternalRecordWrapper wrap(StructLike record) {
        this.wrapped = record;
        return this;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        if (this.transforms[pos] != null) {
            Object value = this.wrapped.get(pos, Object.class);
            if (value == null) {
                return null;
            }
            return javaClass.cast(this.transforms[pos].apply(value));
        }
        return this.wrapped.get(pos, javaClass);
    }

    @Override
    public <T> void set(int pos, T value) {
        throw new UnsupportedOperationException("Cannot update InternalRecordWrapper");
    }
}

