/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.aws.AwsClientFactories;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.PropertyUtil;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkSyncClientBuilder;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.GlueClientBuilder;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AssumeRoleAwsClientFactory
implements AwsClientFactory {
    private static final SdkHttpClient HTTP_CLIENT_DEFAULT = UrlConnectionHttpClient.create();
    private String roleArn;
    private String externalId;
    private int timeout;
    private String region;
    private String s3Endpoint;

    @Override
    public S3Client s3() {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().applyMutation(this::configure)).applyMutation(builder -> AwsClientFactories.configureEndpoint(builder, this.s3Endpoint))).build();
    }

    @Override
    public GlueClient glue() {
        return (GlueClient)((GlueClientBuilder)GlueClient.builder().applyMutation(this::configure)).build();
    }

    @Override
    public KmsClient kms() {
        return (KmsClient)((KmsClientBuilder)KmsClient.builder().applyMutation(this::configure)).build();
    }

    @Override
    public DynamoDbClient dynamo() {
        return (DynamoDbClient)((DynamoDbClientBuilder)DynamoDbClient.builder().applyMutation(this::configure)).build();
    }

    @Override
    public void initialize(Map<String, String> properties) {
        this.roleArn = properties.get("client.assume-role.arn");
        Preconditions.checkNotNull(this.roleArn, "Cannot initialize AssumeRoleClientConfigFactory with null role ARN");
        this.timeout = PropertyUtil.propertyAsInt(properties, "client.assume-role.timeout-sec", 3600);
        this.externalId = properties.get("client.assume-role.external-id");
        this.region = properties.get("client.assume-role.region");
        Preconditions.checkNotNull(this.region, "Cannot initialize AssumeRoleClientConfigFactory with null region");
        this.s3Endpoint = properties.get("s3.endpoint");
    }

    private <T extends AwsClientBuilder & AwsSyncClientBuilder> T configure(T clientBuilder) {
        AssumeRoleRequest request = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(this.roleArn).roleSessionName(this.genSessionName()).durationSeconds(Integer.valueOf(this.timeout)).externalId(this.externalId).build();
        clientBuilder.credentialsProvider((AwsCredentialsProvider)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient((StsClient)((StsClientBuilder)StsClient.builder().httpClient(HTTP_CLIENT_DEFAULT)).build())).refreshRequest(request).build());
        clientBuilder.region(Region.of((String)this.region));
        ((SdkSyncClientBuilder)clientBuilder).httpClient(HTTP_CLIENT_DEFAULT);
        return clientBuilder;
    }

    private String genSessionName() {
        return String.format("iceberg-aws-%s", UUID.randomUUID());
    }
}

