/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

public class HashCodeUtil {
    public static int calculateIntHashCode(int key) {
        key = ~key + (key << 15);
        key ^= key >>> 12;
        key += key << 2;
        key ^= key >>> 4;
        key *= 2057;
        key ^= key >>> 16;
        return key;
    }

    public static int calculateLongHashCode(long key) {
        key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 21);
        key ^= key >>> 24;
        key = key + (key << 3) + (key << 8);
        key ^= key >>> 14;
        key = key + (key << 2) + (key << 4);
        key ^= key >>> 28;
        key += key << 31;
        return (int)key;
    }

    public static void calculateLongArrayHashCodes(long[] longs, int[] hashCodes, int count) {
        for (int v = 0; v < count; ++v) {
            long key = longs[v];
            key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 21);
            key ^= key >>> 24;
            key = key + (key << 3) + (key << 8);
            key ^= key >>> 14;
            key = key + (key << 2) + (key << 4);
            key ^= key >>> 28;
            key += key << 31;
            hashCodes[v] = (int)key;
        }
    }

    public static int calculateBytesHashCode(byte[] keyBytes, int keyStart, int keyLength) {
        return HashCodeUtil.murmurHash(keyBytes, keyStart, keyLength);
    }

    public static void calculateBytesArrayHashCodes(byte[][] bytesArrays, int[] starts, int[] lengths, int[] valueSelected, int[] hashCodes, int count) {
        for (int i = 0; i < count; ++i) {
            int batchIndex = valueSelected[i];
            hashCodes[i] = HashCodeUtil.murmurHash(bytesArrays[batchIndex], starts[batchIndex], lengths[batchIndex]);
        }
    }

    public static int murmurHash(byte[] data, int offset, int length) {
        int m3 = 1540483477;
        int r = 24;
        int h2 = length;
        int len_4 = length >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = offset + (i << 2);
            int k = data[i_4 + 3];
            k <<= 8;
            k |= data[i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 0] & 0xFF;
            k *= m3;
            k ^= k >>> r;
            h2 *= m3;
            h2 ^= (k *= m3);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        if (left != 0) {
            length += offset;
            if (left >= 3) {
                h2 ^= data[length - 3] << 16;
            }
            if (left >= 2) {
                h2 ^= data[length - 2] << 8;
            }
            if (left >= 1) {
                h2 ^= data[length - 1];
            }
            h2 *= m3;
        }
        h2 ^= h2 >>> 13;
        h2 *= m3;
        h2 ^= h2 >>> 15;
        return h2;
    }
}

