/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableMapObjectInspector;

public class StandardMapObjectInspector
implements SettableMapObjectInspector {
    private ObjectInspector mapKeyObjectInspector;
    private ObjectInspector mapValueObjectInspector;

    protected StandardMapObjectInspector() {
    }

    protected StandardMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector) {
        this.mapKeyObjectInspector = mapKeyObjectInspector;
        this.mapValueObjectInspector = mapValueObjectInspector;
    }

    @Override
    public ObjectInspector getMapKeyObjectInspector() {
        return this.mapKeyObjectInspector;
    }

    @Override
    public ObjectInspector getMapValueObjectInspector() {
        return this.mapValueObjectInspector;
    }

    @Override
    public Object getMapValueElement(Object data, Object key) {
        if (data == null || key == null) {
            return null;
        }
        Map map = (Map)data;
        return map.get(key);
    }

    @Override
    public int getMapSize(Object data) {
        if (data == null) {
            return -1;
        }
        Map map = (Map)data;
        return map.size();
    }

    @Override
    public Map<?, ?> getMap(Object data) {
        if (data == null) {
            return null;
        }
        Map map = (Map)data;
        return map;
    }

    @Override
    public final ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.MAP;
    }

    @Override
    public String getTypeName() {
        return "map<" + this.mapKeyObjectInspector.getTypeName() + "," + this.mapValueObjectInspector.getTypeName() + ">";
    }

    @Override
    public Object create() {
        HashMap m3 = new HashMap();
        return m3;
    }

    @Override
    public Object clear(Object map) {
        HashMap m3 = (HashMap)map;
        m3.clear();
        return m3;
    }

    @Override
    public Object put(Object map, Object key, Object value) {
        HashMap m3 = (HashMap)map;
        m3.put(key, value);
        return m3;
    }

    @Override
    public Object remove(Object map, Object key) {
        HashMap m3 = (HashMap)map;
        m3.remove(key);
        return m3;
    }
}

