/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.ISupportStreamingModeForWindowing;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WindowFunctionDescription(description=@Description(name="rank", value="_FUNC_(x)"), supportsWindow=false, pivotResult=true, rankingFunction=true, impliesOrder=true)
public class GenericUDAFRank
extends AbstractGenericUDAFResolver {
    static final Logger LOG = LoggerFactory.getLogger((String)GenericUDAFRank.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length < 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "One or more arguments are expected.");
        }
        for (int i = 0; i < parameters.length; ++i) {
            ObjectInspector oi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(parameters[i]);
            if (ObjectInspectorUtils.compareSupported(oi)) continue;
            throw new UDFArgumentTypeException(i, "Cannot support comparison of map<> type or complex type containing map<>.");
        }
        return this.createEvaluator();
    }

    protected GenericUDAFAbstractRankEvaluator createEvaluator() {
        return new GenericUDAFRankEvaluator();
    }

    public static int compare(Object[] o1, ObjectInspector[] oi1, Object[] o2, ObjectInspector[] oi2) {
        int c = 0;
        for (int i = 0; i < oi1.length; ++i) {
            c = ObjectInspectorUtils.compare(o1[i], oi1[i], o2[i], oi2[i]);
            if (c == 0) continue;
            return c;
        }
        return c;
    }

    public static Object[] copyToStandardObject(Object[] o, ObjectInspector[] oi, ObjectInspectorUtils.ObjectInspectorCopyOption objectInspectorOption) {
        Object[] out = new Object[o.length];
        for (int i = 0; i < oi.length; ++i) {
            out[i] = ObjectInspectorUtils.copyToStandardObject(o[i], oi[i], objectInspectorOption);
        }
        return out;
    }

    public static class GenericUDAFRankEvaluator
    extends GenericUDAFAbstractRankEvaluator
    implements ISupportStreamingModeForWindowing {
        @Override
        public Object getNextResult(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((RankBuffer)agg).rowNums.get(0);
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrmDef) {
            this.isStreamingMode = true;
            return this;
        }

        @Override
        public int getRowsRemainingAfterTerminate() throws HiveException {
            return 0;
        }
    }

    public static abstract class GenericUDAFAbstractRankEvaluator
    extends GenericUDAFEvaluator {
        ObjectInspector[] inputOI;
        ObjectInspector[] outputOI;
        boolean isStreamingMode = false;

        protected boolean isStreaming() {
            return this.isStreamingMode;
        }

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m3, ObjectInspector[] parameters) throws HiveException {
            super.init(m3, parameters);
            if (m3 != GenericUDAFEvaluator.Mode.COMPLETE) {
                throw new HiveException("Only COMPLETE mode supported for Rank function");
            }
            this.inputOI = parameters;
            this.outputOI = new ObjectInspector[this.inputOI.length];
            for (int i = 0; i < this.inputOI.length; ++i) {
                this.outputOI[i] = ObjectInspectorUtils.getStandardObjectInspector(this.inputOI[i], ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            }
            return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new RankBuffer(this.inputOI.length, this.isStreamingMode);
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((RankBuffer)agg).init();
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            RankBuffer rb = (RankBuffer)agg;
            int c = GenericUDAFRank.compare(rb.currVal, this.outputOI, parameters, this.inputOI);
            rb.incrRowNum();
            if (rb.currentRowNum == 1 || c != 0) {
                this.nextRank(rb);
                rb.currVal = GenericUDAFRank.copyToStandardObject(parameters, this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            }
            rb.addRank();
        }

        protected void nextRank(RankBuffer rb) {
            rb.currentRank = rb.currentRowNum;
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            throw new HiveException("terminatePartial not supported");
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            throw new HiveException("merge not supported");
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((RankBuffer)agg).rowNums;
        }
    }

    static class RankBuffer
    implements GenericUDAFEvaluator.AggregationBuffer {
        ArrayList<IntWritable> rowNums;
        int currentRowNum;
        Object[] currVal;
        int currentRank;
        int numParams;
        boolean supportsStreaming;

        RankBuffer(int numParams, boolean supportsStreaming) {
            this.numParams = numParams;
            this.supportsStreaming = supportsStreaming;
            this.init();
        }

        void init() {
            this.rowNums = new ArrayList();
            this.currentRowNum = 0;
            this.currentRank = 0;
            this.currVal = new Object[this.numParams];
            if (this.supportsStreaming) {
                this.rowNums.add(null);
            }
        }

        void incrRowNum() {
            ++this.currentRowNum;
        }

        void addRank() {
            if (this.supportsStreaming) {
                this.rowNums.set(0, new IntWritable(this.currentRank));
            } else {
                this.rowNums.add(new IntWritable(this.currentRank));
            }
        }
    }
}

