/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.io.Text;

@Description(name="reverse", value="_FUNC_(str) - reverse str", extended="Example:\n  > SELECT _FUNC_('Facebook') FROM src LIMIT 1;\n  'koobecaF'")
public class UDFReverse
extends UDF {
    private final Text result = new Text();

    private void reverse(byte[] arr, int first, int last) {
        for (int i = 0; i < (last - first + 1) / 2; ++i) {
            byte temp = arr[last - i];
            arr[last - i] = arr[first + i];
            arr[first + i] = temp;
        }
    }

    public Text evaluate(Text s2) {
        if (s2 == null) {
            return null;
        }
        this.result.set(s2);
        byte[] data = this.result.getBytes();
        int prev = 0;
        for (int i = 1; i < this.result.getLength(); ++i) {
            if (!GenericUDFUtils.isUtfStartByte(data[i])) continue;
            this.reverse(data, prev, i - 1);
            prev = i;
        }
        this.reverse(data, prev, this.result.getLength() - 1);
        this.reverse(data, 0, this.result.getLength() - 1);
        return this.result;
    }
}

