/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;

@Description(name="regexp_extract", value="_FUNC_(str, regexp[, idx]) - extracts a group that matches regexp", extended="Example:\n  > SELECT _FUNC_('100-200', '(\\d+)-(\\d+)', 1) FROM src LIMIT 1;\n  '100'")
public class UDFRegExpExtract
extends UDF {
    private String lastRegex = null;
    private Pattern p = null;

    public String evaluate(String s2, String regex, Integer extractIndex) {
        Matcher m3;
        if (s2 == null || regex == null) {
            return null;
        }
        if (!regex.equals(this.lastRegex) || this.p == null) {
            this.lastRegex = regex;
            this.p = Pattern.compile(regex);
        }
        if ((m3 = this.p.matcher(s2)).find()) {
            MatchResult mr = m3.toMatchResult();
            return mr.group(extractIndex);
        }
        return "";
    }

    public String evaluate(String s2, String regex) {
        return this.evaluate(s2, regex, 1);
    }
}

