/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;

@Description(name="parse_url", value="_FUNC_(url, partToExtract[, key]) - extracts a part from a URL", extended="Parts: HOST, PATH, QUERY, REF, PROTOCOL, AUTHORITY, FILE, USERINFO\nkey specifies which query to extract\nExample:\n  > SELECT _FUNC_('http://facebook.com/path/p1.php?query=1', 'HOST') FROM src LIMIT 1;\n  'facebook.com'\n  > SELECT _FUNC_('http://facebook.com/path/p1.php?query=1', 'QUERY') FROM src LIMIT 1;\n  'query=1'\n  > SELECT _FUNC_('http://facebook.com/path/p1.php?query=1', 'QUERY', 'query') FROM src LIMIT 1;\n  '1'")
public class UDFParseUrl
extends UDF {
    private String lastUrlStr = null;
    private URL url = null;
    private Pattern p = null;
    private String lastKey = null;

    public String evaluate(String urlStr, String partToExtract) {
        if (urlStr == null || partToExtract == null) {
            return null;
        }
        if (this.lastUrlStr == null || !urlStr.equals(this.lastUrlStr)) {
            try {
                this.url = new URL(urlStr);
            }
            catch (Exception e) {
                return null;
            }
        }
        this.lastUrlStr = urlStr;
        if (partToExtract.equals("HOST")) {
            return this.url.getHost();
        }
        if (partToExtract.equals("PATH")) {
            return this.url.getPath();
        }
        if (partToExtract.equals("QUERY")) {
            return this.url.getQuery();
        }
        if (partToExtract.equals("REF")) {
            return this.url.getRef();
        }
        if (partToExtract.equals("PROTOCOL")) {
            return this.url.getProtocol();
        }
        if (partToExtract.equals("FILE")) {
            return this.url.getFile();
        }
        if (partToExtract.equals("AUTHORITY")) {
            return this.url.getAuthority();
        }
        if (partToExtract.equals("USERINFO")) {
            return this.url.getUserInfo();
        }
        return null;
    }

    public String evaluate(String urlStr, String partToExtract, String key) {
        if (!partToExtract.equals("QUERY")) {
            return null;
        }
        String query = this.evaluate(urlStr, partToExtract);
        if (query == null) {
            return null;
        }
        if (!key.equals(this.lastKey)) {
            this.p = Pattern.compile("(&|^)" + key + "=([^&]*)");
        }
        this.lastKey = key;
        Matcher m3 = this.p.matcher(query);
        if (m3.find()) {
            return m3.group(2);
        }
        return null;
    }
}

