/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColLikeStringScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectStringColLikeStringScalar;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.Text;

@Description(name="like", value="_FUNC_(str, pattern) - Checks if str matches pattern", extended="Example:\n  > SELECT a.* FROM srcpart a WHERE a.hr _FUNC_ '%2' LIMIT 1;\n  27      val_27  2008-04-08      12")
@VectorizedExpressions(value={FilterStringColLikeStringScalar.class, SelectStringColLikeStringScalar.class})
public class UDFLike
extends UDF {
    private final Text lastLikePattern = new Text();
    private Pattern p = null;
    private PatternType type = PatternType.NONE;
    private final Text simplePattern = new Text();
    private final BooleanWritable result = new BooleanWritable();

    public static String likePatternToRegExp(String likePattern) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < likePattern.length(); ++i) {
            char n = likePattern.charAt(i);
            if (n == '\\' && i + 1 < likePattern.length() && (likePattern.charAt(i + 1) == '_' || likePattern.charAt(i + 1) == '%')) {
                sb.append(likePattern.charAt(i + 1));
                ++i;
                continue;
            }
            if (n == '_') {
                sb.append(".");
                continue;
            }
            if (n == '%') {
                sb.append(".*?");
                continue;
            }
            sb.append(Pattern.quote(Character.toString(n)));
        }
        return sb.toString();
    }

    private void parseSimplePattern(String likePattern) {
        int length = likePattern.length();
        int beginIndex = 0;
        int endIndex = length;
        int lastChar = 97;
        String strPattern = new String();
        this.type = PatternType.NONE;
        for (int i = 0; i < length; ++i) {
            char n = likePattern.charAt(i);
            if (n == '_') {
                if (lastChar != 92) {
                    this.type = PatternType.COMPLEX;
                    return;
                }
                strPattern = strPattern + likePattern.substring(beginIndex, i - 1);
                beginIndex = i;
            } else if (n == '%') {
                if (i == 0) {
                    this.type = PatternType.END;
                    beginIndex = 1;
                } else if (i < length - 1) {
                    if (lastChar != 92) {
                        this.type = PatternType.COMPLEX;
                        return;
                    }
                    strPattern = strPattern + likePattern.substring(beginIndex, i - 1);
                    beginIndex = i;
                } else if (lastChar != 92) {
                    endIndex = length - 1;
                    this.type = this.type == PatternType.END ? PatternType.MIDDLE : PatternType.BEGIN;
                } else {
                    strPattern = strPattern + likePattern.substring(beginIndex, i - 1);
                    beginIndex = i;
                    endIndex = length;
                }
            }
            lastChar = n;
        }
        strPattern = strPattern + likePattern.substring(beginIndex, endIndex);
        this.simplePattern.set(strPattern);
    }

    private static boolean find(Text s2, Text sub, int startS, int endS) {
        byte[] byteS = s2.getBytes();
        byte[] byteSub = sub.getBytes();
        int lenSub = sub.getLength();
        boolean match = false;
        block0: for (int i = startS; i < endS - lenSub + 1 && !match; ++i) {
            match = true;
            for (int j = 0; j < lenSub; ++j) {
                if (byteS[j + i] == byteSub[j]) continue;
                match = false;
                continue block0;
            }
        }
        return match;
    }

    public BooleanWritable evaluate(Text s2, Text likePattern) {
        if (s2 == null || likePattern == null) {
            return null;
        }
        if (!likePattern.equals((Object)this.lastLikePattern)) {
            this.lastLikePattern.set(likePattern);
            String strLikePattern = likePattern.toString();
            this.parseSimplePattern(strLikePattern);
            if (this.type == PatternType.COMPLEX) {
                this.p = Pattern.compile(UDFLike.likePatternToRegExp(strLikePattern));
            }
        }
        if (this.type == PatternType.COMPLEX) {
            Matcher m3 = this.p.matcher(s2.toString());
            this.result.set(m3.matches());
        } else {
            int startS = 0;
            int endS = s2.getLength();
            if (endS < this.simplePattern.getLength()) {
                this.result.set(false);
                return this.result;
            }
            switch (this.type) {
                case BEGIN: {
                    endS = this.simplePattern.getLength();
                    break;
                }
                case END: {
                    startS = endS - this.simplePattern.getLength();
                    break;
                }
                case NONE: {
                    if (this.simplePattern.getLength() == s2.getLength()) break;
                    this.result.set(false);
                    return this.result;
                }
            }
            this.result.set(UDFLike.find(s2, this.simplePattern, startS, endS));
        }
        return this.result;
    }

    private static enum PatternType {
        NONE,
        BEGIN,
        END,
        MIDDLE,
        COMPLEX;

    }
}

