/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import org.apache.hadoop.hive.ql.metadata.Dimension;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class Sample {
    protected int sampleNum;
    protected int sampleFraction;
    protected Dimension sampleDimension;
    protected int moduloNum;

    public Sample(int num, int fraction, Dimension d) throws HiveException {
        if (num <= 0 || num > fraction) {
            throw new HiveException("Bad sample spec: " + num + "/" + fraction);
        }
        this.sampleNum = num;
        this.moduloNum = this.sampleNum - 1;
        this.sampleFraction = fraction;
        this.sampleDimension = d;
    }

    public boolean inSample(Object o) {
        return (this.sampleDimension.hashCode(o) & Integer.MAX_VALUE) % this.sampleFraction == this.moduloNum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Sample) {
            Sample s2 = (Sample)o;
            return this.sampleNum == s2.sampleNum && this.sampleFraction == s2.sampleFraction && this.sampleDimension.equals(s2.sampleDimension);
        }
        return false;
    }

    public int getSampleNum() {
        return this.sampleNum;
    }

    public int getSampleFraction() {
        return this.sampleFraction;
    }

    public Dimension getSampleDimension() {
        return this.sampleDimension;
    }

    public String toString() {
        return this.sampleNum + "/" + this.sampleFraction + "@(" + this.sampleDimension + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sampleDimension == null ? 0 : this.sampleDimension.hashCode());
        result = 31 * result + this.sampleFraction;
        result = 31 * result + this.sampleNum;
        return result;
    }
}

