/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class RuleRegExp
implements Rule {
    private final String ruleName;
    private final Pattern patternWithWildCardChar;
    private final String patternWithoutWildCardChar;
    private String[] patternORWildChar;
    private static final Set<Character> wildCards = new HashSet<Character>(Arrays.asList(Character.valueOf('['), Character.valueOf('^'), Character.valueOf('$'), Character.valueOf('*'), Character.valueOf(']'), Character.valueOf('+'), Character.valueOf('|'), Character.valueOf('('), Character.valueOf('\\'), Character.valueOf('.'), Character.valueOf('?'), Character.valueOf(')'), Character.valueOf('&')));

    private static boolean patternHasWildCardChar(String pattern) {
        if (pattern == null) {
            return false;
        }
        for (char pc : pattern.toCharArray()) {
            if (!wildCards.contains(Character.valueOf(pc))) continue;
            return true;
        }
        return false;
    }

    private static boolean patternHasOnlyWildCardChar(String pattern, char wcc) {
        if (pattern == null) {
            return false;
        }
        boolean ret = true;
        boolean hasWildCard = false;
        for (char pc : pattern.toCharArray()) {
            if (!wildCards.contains(Character.valueOf(pc))) continue;
            hasWildCard = true;
            ret = ret && pc == wcc;
        }
        return ret && hasWildCard;
    }

    public RuleRegExp(String ruleName, String regExp) {
        this.ruleName = ruleName;
        if (RuleRegExp.patternHasWildCardChar(regExp)) {
            if (RuleRegExp.patternHasOnlyWildCardChar(regExp, '|')) {
                this.patternWithWildCardChar = null;
                this.patternWithoutWildCardChar = null;
                this.patternORWildChar = regExp.split("\\|");
            } else {
                this.patternWithWildCardChar = Pattern.compile(regExp);
                this.patternWithoutWildCardChar = null;
                this.patternORWildChar = null;
            }
        } else {
            this.patternWithWildCardChar = null;
            this.patternWithoutWildCardChar = regExp;
            this.patternORWildChar = null;
        }
    }

    private int costPatternWithoutWildCardChar(Stack<Node> stack) throws SemanticException {
        int numElems;
        int n = numElems = stack != null ? stack.size() : 0;
        if (numElems == 0) {
            return -1;
        }
        int patLen = this.patternWithoutWildCardChar.length();
        StringBuilder name = new StringBuilder(patLen + numElems);
        for (int pos = numElems - 1; pos >= 0; --pos) {
            String nodeName = ((Node)stack.get(pos)).getName() + "%";
            name.insert(0, nodeName);
            if (name.length() < patLen) continue;
            if (!this.patternWithoutWildCardChar.contentEquals(name)) break;
            return patLen;
        }
        return -1;
    }

    private int costPatternWithORWildCardChar(Stack<Node> stack) throws SemanticException {
        int numElems;
        int n = numElems = stack != null ? stack.size() : 0;
        if (numElems == 0) {
            return -1;
        }
        HashMap<Integer, String> cachedNames = new HashMap<Integer, String>();
        int maxDepth = numElems;
        int maxLength = 0;
        block0: for (String pattern : this.patternORWildChar) {
            int patLen = pattern.length();
            if (cachedNames.containsKey(patLen)) {
                if (!pattern.contentEquals((CharSequence)cachedNames.get(patLen))) continue;
                return patLen;
            }
            if (maxLength >= patLen) continue;
            StringBuilder name = new StringBuilder(patLen + numElems);
            if (maxLength != 0) {
                name.append((String)cachedNames.get(maxLength));
            }
            for (int pos = maxDepth - 1; pos >= 0; --pos) {
                String nodeName = ((Node)stack.get(pos)).getName() + "%";
                name.insert(0, nodeName);
                cachedNames.put(name.length(), name.toString());
                maxLength = name.length();
                --maxDepth;
                if (name.length() < patLen) continue;
                if (!pattern.contentEquals(name)) continue block0;
                return patLen;
            }
        }
        return -1;
    }

    private int costPatternWithWildCardChar(Stack<Node> stack) throws SemanticException {
        int numElems = stack != null ? stack.size() : 0;
        StringBuilder name = new StringBuilder();
        Matcher m3 = this.patternWithWildCardChar.matcher("");
        for (int pos = numElems - 1; pos >= 0; --pos) {
            String nodeName = ((Node)stack.get(pos)).getName() + "%";
            name.insert(0, nodeName);
            m3.reset(name);
            if (!m3.matches()) continue;
            return name.length();
        }
        return -1;
    }

    boolean rulePatternIsValidWithWildCardChar() {
        return this.patternWithoutWildCardChar == null && this.patternWithWildCardChar != null && this.patternORWildChar == null;
    }

    boolean rulePatternIsValidWithoutWildCardChar() {
        return this.patternWithWildCardChar == null && this.patternWithoutWildCardChar != null && this.patternORWildChar == null;
    }

    boolean rulePatternIsValidWithORWildCardChar() {
        return this.patternWithoutWildCardChar == null && this.patternWithWildCardChar == null && this.patternORWildChar != null;
    }

    @Override
    public int cost(Stack<Node> stack) throws SemanticException {
        if (this.rulePatternIsValidWithoutWildCardChar()) {
            return this.costPatternWithoutWildCardChar(stack);
        }
        if (this.rulePatternIsValidWithWildCardChar()) {
            return this.costPatternWithWildCardChar(stack);
        }
        if (this.rulePatternIsValidWithORWildCardChar()) {
            return this.costPatternWithORWildCardChar(stack);
        }
        throw new SemanticException("Rule pattern is invalid for " + this.getName() + " : patternWithWildCardChar = " + this.patternWithWildCardChar + " patternWithoutWildCardChar = " + this.patternWithoutWildCardChar);
    }

    @Override
    public String getName() {
        return this.ruleName;
    }
}

