/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalColumnBetween;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterDecimalColumnBetweenDynamicValue
extends FilterDecimalColumnBetween {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FilterDecimalColumnBetweenDynamicValue.class);
    protected DynamicValue leftDynamicValue;
    protected DynamicValue rightDynamicValue;
    protected transient boolean initialized = false;
    protected transient boolean isLeftOrRightNull = false;

    public FilterDecimalColumnBetweenDynamicValue(int colNum, DynamicValue leftValue, DynamicValue rightValue) {
        super(colNum, HiveDecimal.ZERO, HiveDecimal.ZERO);
        this.leftDynamicValue = leftValue;
        this.rightDynamicValue = rightValue;
    }

    public FilterDecimalColumnBetweenDynamicValue() {
    }

    public DynamicValue getLeftDynamicValue() {
        return this.leftDynamicValue;
    }

    public void setLeftDynamicValue(DynamicValue leftValue) {
        this.leftDynamicValue = leftValue;
    }

    public DynamicValue getRightDynamicValue() {
        return this.rightDynamicValue;
    }

    public void getRightDynamicValue(DynamicValue rightValue) {
        this.rightDynamicValue = rightValue;
    }

    @Override
    public void init(Configuration conf) {
        super.init(conf);
        this.leftDynamicValue.setConf(conf);
        this.rightDynamicValue.setConf(conf);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (!this.initialized) {
            Object lVal = this.leftDynamicValue.getValue();
            Object rVal = this.rightDynamicValue.getValue();
            if (lVal == null || rVal == null) {
                this.isLeftOrRightNull = true;
            } else {
                HiveDecimal min2 = PrimitiveObjectInspectorUtils.getHiveDecimal(lVal, this.leftDynamicValue.getObjectInspector());
                this.setLeftValue(min2);
                HiveDecimal max = PrimitiveObjectInspectorUtils.getHiveDecimal(rVal, this.rightDynamicValue.getObjectInspector());
                this.setRightValue(max);
            }
            this.initialized = true;
        }
        if (this.isLeftOrRightNull) {
            batch.size = 0;
        }
        super.evaluate(batch);
    }
}

