/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class StringLength
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;

    public StringLength(int colNum, int outputColumn) {
        this();
        this.colNum = colNum;
        this.outputColumn = outputColumn;
    }

    public StringLength() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.colNum];
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] start = inputColVector.start;
        int[] length = inputColVector.length;
        long[] resultLen = outV.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector.noNulls) {
            outV.noNulls = true;
            if (inputColVector.isRepeating) {
                outV.isRepeating = true;
                resultLen[0] = StringLength.utf8StringLength(vector[0], start[0], length[0]);
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    resultLen[i] = StringLength.utf8StringLength(vector[i], start[i], length[i]);
                }
                outV.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    resultLen[i] = StringLength.utf8StringLength(vector[i], start[i], length[i]);
                }
                outV.isRepeating = false;
            }
        } else {
            outV.noNulls = false;
            if (inputColVector.isRepeating) {
                outV.isRepeating = true;
                outV.isNull[0] = inputColVector.isNull[0];
                if (!inputColVector.isNull[0]) {
                    resultLen[0] = StringLength.utf8StringLength(vector[0], start[0], length[0]);
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!inputColVector.isNull[i]) {
                        resultLen[i] = StringLength.utf8StringLength(vector[i], start[i], length[i]);
                    }
                    outV.isNull[i] = inputColVector.isNull[i];
                }
                outV.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    if (!inputColVector.isNull[i]) {
                        resultLen[i] = StringLength.utf8StringLength(vector[i], start[i], length[i]);
                    }
                    outV.isNull[i] = inputColVector.isNull[i];
                }
                outV.isRepeating = false;
            }
        }
    }

    static long utf8StringLength(byte[] s2, int start, int len) {
        long resultLength = 0L;
        for (int i = start; i < start + len; ++i) {
            if ((s2[i] & 0xC0) == 128) continue;
            ++resultLength;
        }
        return resultLength;
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "Long";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

